#ifndef MAIN_H
 #define MAIN_H

//constants
#define F_CPU 8000000 // 8 Mhz, for UART and delay calculation


//Whic input is connected to which A/D converter
#define DISTANCE_AD_PIN 0      //Sharp distance sensor
#define SERVO_RESISTOR_PIN 1  //Resistor
#define EXTIN1_PIN 5
#define EXTIN2_PIN 4


//External functios
#include <avr/io.h>
#include <inttypes.h>
#include <avr/interrupt.h>
#include <string.h>
#include <avr/pgmspace.h>
#include <avr/eeprom.h>
#include <util/delay.h>
#include <math.h>
#include <avr/wdt.h>

//Look into inttypes.h to know what unit8_t means.
typedef uint8_t  u08;
typedef int8_t   s08;
typedef uint16_t u16;
typedef int16_t  s16;
typedef uint32_t u32;
typedef int32_t  s32;

#include "uart.h"
#include "servo.h"
#include "table1.h"
#include "basicad.h"
#include "lcd.h"
#include "formatter.h"
#include "keys.h"

extern u08 volatile reading_blocking;

#endif
