/*UART Functions
  Version 1.10
  (c) 2004, 2008 by Malte Marwedel
  www.marwedels.de/malte

  This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/
#ifndef UART_H
 #define UART_H

#include <main.h>
#include <avr/io.h>
#include <avr/interrupt.h>

#define BAUDRATE 9600     // 9600 Baud
#define UARTNUMBER (F_CPU/(BAUDRATE*16l)-1)

#define UART_RX_BUF_SIZE 32
#define UART_TX_BUF_SIZE 64

void uart_init(void);
SIGNAL(SIG_UART_RECV);
void uart_putchar(u08 c);
u08 uart_rx_available(void);
u08 uart_tx_free(void);
u08 uart_rx_get(void);
u08 uart_error_get(void);

#endif
