package control;

/*
* 3D Scanner Control Version 1.0 (c) 2009 by Malte Marwedel

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/**
 * Forwards the streams of the application to stdout
 * @author Malte Marwedel
 *
 */

public class OutputForwarder implements Runnable{

	private Process watch;
	
	public OutputForwarder(Process p) {
		watch = p;
		Thread t = new Thread(this);
		t.start();
	}

	public void run() {
		boolean running = true;
		int estate = 42; //value is never printed. 
		do {
			try {
				estate = watch.exitValue();
				running = false;
			} catch (IllegalThreadStateException e) {
				//good. its still running.
				//TODO is there any better way to query if the thread is running or not?
			}
			try {
				int avar = watch.getInputStream().available();
				if (avar > 0) {
					byte foo[] = new byte[avar];
					watch.getInputStream().read(foo, 0, avar);
					System.out.write(foo);
				}
				avar = watch.getErrorStream().available();
				if (avar > 0) {
					byte bar[] = new byte[avar];
					watch.getErrorStream().read(bar, 0, avar);
					System.out.write(bar);
				}
			} catch (Exception e) {
				//who cares
			}
			try {
				Thread.sleep(100);
			} catch (InterruptedException e) {
				//who cares
			}
		} while (running);
		System.out.println("OutputForwarder.run: Process finished with state: "+estate);
	}

}
