package control;

/* Charge Control Version 1.1 (c) 2008 by Malte Marwedel
 * Modified for 3D Scanner Control Version 1.0 (c) 2009 by Malte Marwedel


This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

import java.io.File;
import java.io.IOException;
import java.io.InputStream;

public class Tools {

  public static final String newline = "\r\n";
  
  
  public static String extractline(InputStream fread) {
    String line = new String();
    int t;                      //Temp 1
    char[] t2 = new char[1];    //Temp 2
    String t3;                  //Temp 3

    try {
      while (t2[0] != '\n') {
        t = fread.read();
        if ( t < 0) {           //End of file
          break;
        }
        t2[0] = (char)t;        //Some idiotic
        t3 = new String(t2);    //More idiotic
        if (t2[0] != '\n')
          line = line.concat(t3);        //Idiotic too
      }
    } catch (IOException e) {
    }
    return line;
  }

  /**
   * Converts a positive int to a string with leading zeros. Too long numbers will be cut.
   * Negative numbers will be handled as if they are 0. 
   * @param number the number to convert
   * @param digits length of the resulting number/strings 
   * @return a new string
   */
	public static String intToStr(int number, int digits) {
		if (number < 0)
			number = 0;
		String str = String.valueOf(number);
		for (int i = str.length(); i <= digits; i++) {
			str = "0"+str; 
		}
		if (str.length() > digits) { //simply crop if number too large
			str = str.substring(str.length()-digits, str.length());
		}
		return str;
	}
  
	/**
	 * Uses an exception to show who called this function.
	 * @return 0
	 */
	public static int debugWho() {
		int a = 1;
		int b = 0;
		int c;
		try {
			c = a/b;
		} catch (Exception e) {
			System.out.println("This call came from:");
			e.printStackTrace();
			return 0;
		}
		return c; //never happens, but Eclipse and the compiler are happy now ;-)
	}

	public static int max(int[] selected) {
		int m = Integer.MIN_VALUE;
		for (int i = 0; i < selected.length; i++) {
			if (selected[i] > m)
				m = selected[i];
		}
		return m;
	}
	
	/**
	 * Replaces an existing file ending with the new ending
	 * @param filename
	 * @param newending
	 * @return
	 */
	public static String replaceFileEnding(String filename, String newending) {
		String suggested;
		int dotpos = filename.lastIndexOf('.');
		int lastseperator = filename.lastIndexOf(File.separatorChar);
  	if (dotpos > lastseperator) {
  		suggested = new String(filename.substring(0, dotpos)+newending);
  	} else if ((filename.length() > 0) && (dotpos <= lastseperator)) {
  		suggested = filename+newending;
  	} else
  		suggested = filename;
		return suggested;
	}
	
	/**
	 * If a file has no valid ending (being a file without a '.' in the filename),
	 * newending is added. This properly works with full paths where the paths have a '.'
	 * too.   
	 * @param filename The filename to check
	 * @param newending new ending like ".txt"
	 * @return The new filename
	 */
	public static String addIfWithoutFileEnding(String filename, String newending) {
		String suggested;
		int dotpos = filename.lastIndexOf('.');
		int lastseperator = filename.lastIndexOf(File.separatorChar);
  	if ((filename.length() > 0) && (dotpos <= lastseperator)) {
  		suggested = filename+newending;
  	} else
  		suggested = filename;
		return suggested;
	}
	
	public static String intToHex(int number, int mindigits) {
		String str = Integer.toHexString(number);
		while (str.length() < mindigits) {
			str = "0"+str;
		}
		return str;
	}
	
}
