/* formatter.c

Copyright (C) 2008 by Malte Marwedel

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


#include "main.h"

void wordtostr(u08 *s, u16 number, u08 digits, u08 strposition) {
	//converts a unsigned 16 bit number to a string at the base of 10.
	s += strposition;
	while (digits > 0) {
		digits--;
		*(s+digits) = number%10+48;
		number /= 10;
	}
}


/* Converts number into a decimal which is stored at the given char* s.
The maximum value for number is: +-2^14
*/
void inttostr(u08 *s, s16 number, u08 digits, u08 strposition) {
	s += strposition;
	if (number < 0) {
		*(s) = '-';
		number -= number*2; //makes an absolute number
	} else {
		*(s) = '0';
	}
	wordtostr(s, number, digits-1, 1);
}

void print_char(u08 device, u08 ch) {
	if (device == DEV_LCD) {
		lcd_putchar(ch);
	}
	if (device == DEV_UART) {
		uart_putchar(ch);
	}
}

void print(u08 device, u08 *text) {
	while (*(text) != '\0') {
		print_char(device, *(text));
		text++;
	}
}

void print_word(u08 device, u16 value, u08 digits) {
	static u08 text[6];
	/*static is simply an optimization to prevent the compiler for generating long
	code (66 bytes) for making space for the string on the stack. It may be removed
	if program space does not matter and must be removed if this function could be
	called from multiple threads.*/
	if (digits > 5)
		digits = 5;
	text[digits] = '\0';
	wordtostr(text, value, digits, 0);
	print(device, text);
}

void print_sword(u08 device, s16 value, u08 digits) {
	static u08 text[6];
	/*static is simply an optimization to prevent the compiler for generating long
	code (66 bytes) for making space for the string on the stack. It may be removed
	if program space does not matter and must be removed if this function could be
	called from multiple threads.*/
	if (digits > 5)
		digits = 5;
	text[digits] = '\0';
	inttostr(text, value, digits, 0);
	print(device, text);
}

/* I came to the conclusion that using va_arg for a dynamic argument size
  produces always larger code than single calls.
  I am using the method with two parameters now because I have strings with two
  numbers relatively often.
*/
void printw_p(u08 device, PGM_VOID_P text, u16 val1, u16 val2) {
	u08 putchar;
	u16 arg = val1;
	//Count the numbers of parameters in the string
	while (1) {
		//The endless loop with a break is not nice, but saves 6 bytes of flash
		putchar = pgm_read_byte(text);
		if (putchar == '\0') {
			break;
		}
		if ((putchar == '$') || (putchar == '`')) { //we will not need these symbols
			u08 sign = putchar;
			text++;
			putchar = pgm_read_byte(text); //how many digits the number should have
			if (putchar == '\0') {	//just to be safe
				break;
			}
			putchar -= 48;
			if (sign == '$') {
				print_word(device, arg, putchar);
			} else
				print_sword(device, (s16)arg, putchar);
			arg = val2; //switch to the second one
		} else
			print_char(device, putchar);
		text++;
	}
}

/* Puts a string from the flash into the fifo */
void print_p(u08 device, PGM_VOID_P text) {
	printw_p(device, text, 0, 0);
}
