/* formatter.h

Copyright (C) 2008 by Malte Marwedel

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef FORMATTER_H
  #define FORMATTER_H

#include "main.h"

#define DEV_UART 0
#define DEV_LCD 1

void wordtostr(u08 *s, u16 number, u08 digits, u08 strposition);
void inttostr(u08 *s, s16 number, u08 digits, u08 strposition);

void print_char(u08 device, u08 ch);
void print(u08 device, u08 *text);
void print_word(u08 device, u16 value, u08 digits);
void print_sword(u08 device, s16 value, u08 digits);
void printw_p(u08 device, PGM_VOID_P text, u16 val1, u16 val2);
void print_p(u08 device, PGM_VOID_P text);

#endif
