package control.detector;


import data.ChargingData;

import model.FullDetect;

/**
 * Tries to determine if the data are good for a -deltaV or not
 * @author Malte Marwedel
 *
 */
public class BadDetect2 implements FullDetect {

	int finsam;
	
	
	public BadDetect2(ChargingData cd) {
		checkBad(cd);
	}
	
	
	private void checkBad(ChargingData cd) {
		boolean dryrun = true;
		int datarange = cd.getStoppedPercent()-cd.getBeginningPercent();
		if (cd.getStoppedPercent() == -1 && cd.size() > 1000) //adjust to useful if no valid data are saved
			datarange = 100;
		if (datarange <= 0) { //nothing to detect
			finsam = Integer.MAX_VALUE;			
			return;
		}
		//System.out.println(cd.getStoppedPercent()+ " "+cd.getBeginningPercent());
		//int sc = cd.size()/datarange; //how many values are one percent...
		//int numavg = perc*sc;
		int numavg = 240;
		int i = 0;
		int maxreldelta = Integer.MIN_VALUE; //for stats only
		int lastvolt = 0;
		while (i < (cd.size()-numavg)) {
			//min, max, avg
			int vdir = 0;
			int vmin = Integer.MAX_VALUE;
			int vmax = Integer.MIN_VALUE;
			for (int j = 0; j < numavg; j++) {
				int v = cd.getEntry(i+j).getVoltage();
				vmin = Math.min(vmin, v);
				vmax = Math.max(vmax, v);
        vdir = Math.abs(lastvolt-v);
				lastvolt = v;
			}
			int noise = vdir;//(numavg/10);
			i += numavg;
			if (!dryrun) { //do not use the first sampled value
				//int relnoise = noise/(Math.max(vmax-vmin, 1));
				if (noise > 10) { //found
					finsam = i;
					System.out.println("BadDetect.checkBad: Info: Looks bad. Noise is: "+noise);
					return;
				}
				maxreldelta = Math.max(maxreldelta, noise);
			} else
				dryrun = false;
		}
		System.out.println("BadDetect.checkBad: Info: Looks good. Maximum relative delta is: "+maxreldelta);
		finsam = Integer.MAX_VALUE;
		
	}

	
	public int getStopTime() {
		return finsam;
	}
}
