package control.detector;


import data.ChargingData;

import model.FullDetect;

/**
 * Tries to do a -DeltaU detection on the given data
 * @author Malte Marwedel
 *
 */
public class NoDeltaDeltaU implements FullDetect {

	int finsam;
	
	
	public NoDeltaDeltaU(ChargingData cd) {
		findDeltaDelta(cd);
		
	}
	
	
	private void findDeltaDelta(ChargingData cd) {
		int perc = 2;
		int datarange = cd.getStoppedPercent()-cd.getBeginningPercent();
		if (cd.getStoppedPercent() == -1 && cd.size() > 1000) //adjust to useful if no valid data are saved
			datarange = 100;
		if (datarange <= 0) { //nothing to detect
			finsam = Integer.MAX_VALUE;			
			return;
		}
		//System.out.println(cd.getStoppedPercent()+ " "+cd.getBeginningPercent());
		int sc = cd.size()/datarange; //how many values are one percent...
		int numavg = perc*sc;
		int i = 0;
		int oldvolts = 0;
		int olddelta = 1;
		int percdone = 0;
		while (i < (cd.size()-numavg)) {
			//average
			int vsum = 0;
			for (int j = 0; j < numavg; j++) {
				vsum += cd.getEntry(i+j).getVoltage();
			}
			int volts = vsum/numavg;
			i += numavg;
			percdone = i /sc;
			int delta = volts-oldvolts;
			int delta2 = delta-olddelta;
			if (percdone > 50) {
				if (delta2 <= 0) { //found
					finsam = i;
					return;
				}
			}
			oldvolts = volts;
			olddelta = delta;
		}
		finsam = Integer.MAX_VALUE;
		
	}

/*
	private void printArray(int[] arr) {
		for (int i = 0; i < arr.length; i++) {
			System.out.println("NegDeltaU.printArray: arr["+i+"]"+": "+arr[i]);
		}
	}
	*/
	
	public int getStopTime() {
		return finsam;
	}
}
