package data;

/* Charge Control Version 1.1 (c) 2008 by Malte Marwedel

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;

import control.Tools;

import model.RecordedData;

/**
 * Handles data where not directly is known what is says
 * @author Malte Marwedel
 *
 */
public class OtherData implements RecordedData {

	private ArrayList<String> al;
	
	public OtherData(String bufline) {
		al = new ArrayList<String>();
		if (bufline != null)
			al.add(bufline);
	}

	public boolean add(String str) {
		al.add(str);
		return true;
	}

	public void pushToStream(OutputStream outs) throws IOException {
		for (int i = 0; i < al.size(); i++) {
			outs.write((al.get(i)+Tools.newline).getBytes());
		}
	}
	
	public int entries() {
		return al.size();
	}

	public String getDescription() {
    return new String("Unknown Data: "+al.size()+" entries");
  }
	
	public String getByBeginning(String beg) {
		for (int i = 0; i < al.size(); i++) {
			if (al.get(i).startsWith(beg)) {
				return al.get(i).substring(beg.length());
			}
		}
		return null;
	}

}
