/* ad_converter.h
Header file for ad_converter.c

Copyright (C) 2006-2007 by Malte Marwedel

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  US
*/

#ifndef ad_converter_H
 #define ad_converter_H

//this pin is connected to the positive output
#define UPPER_PIN 1

/*This pin is connected to the negative output on charging.
  But on discharge, it measures the current */
#define LOWER_PIN 0

//Pin for internal 1.23V BandGap reference
#define BANDGAP_PIN 0x0e

//num of samples for oversampling
#define MEASURE_SUM 64

void ad_thread(void);
u16 get_current(void);
u16 get_outputvoltage(void);
u16 get_hiresoutputvoltage(void);
u16 get_uppervoltage(void);
u16 get_lowervoltage(void);
u16 get_hiresuppervoltage(void);
u16 get_hireslowervoltage(void);
u16 get_vccvoltage(void);

#endif
