/* calibration_config.h
Header file for calibration_config.c

Copyright (C) 2007 by Malte Marwedel

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  US
*/

#ifndef eeprom_config_H
 #define eeprom_config_H

//if possible use for CAL_CHRG_SELECT_ a multiple of 200
#define CAL_CHRG_SELECT_MAXV 20000
#define CAL_CHRG_SELECT_MAXMILLIAMPHOURS 7400
#define CAL_CHRG_SELECT_MAXCHARGEMILLIAMPS 1000
#define CAL_CHRG_SELECT_MAXDSMILLIAMPS 2400


#define MIN_VCC 4800
#define MIN_VOUT 6600
//maximum power in mW which can be consumed by the radiator
#define MAX_HEAT_POWER 8000

//expected voltage loss between Vcc input and upper output (without the diode)
//in mV
#define CAL_VCC_DROP 2000

//characteristics of a NIMH cell (values in mV)
#define CAL_CELL_VERYEMPTY_V 900
#define CAL_CELL_EMPTY_V 1000
#define CAL_CELL_LOAD_V 1050
#define CAL_CELL_LIGHTLOAD_V 1150
#define CAL_CELL_CHARGED_V 1250
#define CAL_CELL_MAX_V 2000


//Determine voltage lowering for delta charging stop in mV
#define CAL_DELTA_VOLT 100

//Default capacity in mAh
#define CAL_DEFAULT_CAPACITY 200

//Some current (in mA) which for some reason always charge...
#define CAL_CHARGE_OFFSET 2

//Maximum accepted low output voltage on startup test on upper input
#define CAL_START_TEST_MAX_UPPER_VOUT 200

//Maximum accepted low output voltage on startup test on lower input
#define CAL_START_TEST_MAX_LOWER_VOUT 10

/*Default selected charging current (mA)
  (with which value the choice screen starts */
#define DEFAULT_CHARGING_CURRENT 100

/*Default selected maximum voltage (mV) for constant current mode */
#define DEFAULT_MAX_VOLTAGE 1000

#if (CAL_CHRG_SELECT_MAXCHARGEMILLIAMPS >= 4700)
  #error "The maximum charging current must be below the Vcc voltage \
   (in mV)) due to R = U/I with R=1.0 Ohm"
#endif

#define CALIB_ENTRIES 10

/*DO NOT CHANGE! The values need to be the same in the
PC application and have to correspondend with the default EEProm values!!!
Otherwise the behaviour of the program is undefined.
 */
#define CALIB_UPPERSUM 0
#define CALIB_LOWERSUM 2
#define CALIB_R2 4
#define CALIB_R3 6
#define CALIB_L7805VOUT 8
#define CALIB_INVALID 255

extern u16 volatile charger_calib[CALIB_ENTRIES*2];
extern u16 eep_config[CALIB_ENTRIES*2] __attribute__ ((section (".eeprom")));
extern u08 volatile configvalid;

u16 eep_multiplyfactor(u16 value, u08 index);
void eep_loadconf(void);
void eep_defaulconfig(void);
void eep_sendconfig(void);
void eep_receiveconfig(void);

#endif
