/* charging_delta_detect.c
Determines if the battery is full

Copyright (C) 2008 by Malte Marwedel

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  US
*/

#include "main.h"

//has to be 1 or greater
#define VOLTBUFSIZE 3

//Some general status variables
u32 timer;

//variables for the state machine
u16 counter = 0;
u08 samevolts = 0;
u32 sum = 0;
u32 voltsumbuff[VOLTBUFSIZE];
u32 maxv = 0;
u08 firstrounddone = 0;

//set all variables back to beginning
void delta_init(void) {
counter = 0;
samevolts = 0;
sum = 0;
u08 i;
for (i = 0; i < VOLTBUFSIZE; i++) {
  voltsumbuff[i] = 0;
}
maxv = 0;
firstrounddone = 0;
timer_setup(&timer, 30000); //wait first 30sec before beginning
}

void moveBuff(u32 newval) {
u08 i;
for (i = 1; i < VOLTBUFSIZE; i++) { //move the buffer
  voltsumbuff[i] = voltsumbuff[i-1];
  }
voltsumbuff[0] = newval;
}

u32 avgBuff(void) {
u32 volts = 0;
u08 i;
for (i = 0; i < VOLTBUFSIZE; i++) { //calculate average value
  volts += voltsumbuff[i];
}
volts /= VOLTBUFSIZE;
return volts;
}

/*
 A state machine
 call this function every 1/4 second with the current voltage
 */


u08 deltaStep(u16 voltage, u08 perc, u08 samples, u08 steep, u08 cells) {
sum += voltage;
counter++;
if (counter <= samples) { //just add
  return 0;
}
u32 oldsumvolt = avgBuff();
moveBuff(sum);
counter = 0;
sum = 0;
u32 newsumvolt = avgBuff();
//rs232_print_number_u32(newsumvolt);
maxv = max(maxv, newsumvolt);
if (firstrounddone == 0) { //do throw the first values away
  firstrounddone = 1;
  return 0;
}
s32 delta = newsumvolt-oldsumvolt;
if (delta < samples/steep) {
  samevolts++;
  if (delta < 0) {//negative values make detection faster
    samevolts++;
  }
} else if (delta > samples/2) {
  samevolts = 0;
}
if (((newsumvolt+samples*2) < oldsumvolt) && (perc > 70)) {
  //System.out.println("Weak Delta peak detect");
  return 'W';
}
if ((newsumvolt+samples*5) < oldsumvolt) {
  //System.out.println("Strong Delta peak detect");
  return 'S';
}
if ((samevolts >= samples/6) && (perc > 60)) {
  //System.out.println("Voltage does not rise");
  return 'R';// yes, now stop
}
if (((((s32)maxv)-((s32)newsumvolt))/samples) > ((s32)(8*cells))) {
  //System.out.println("Voltage drop detected");
  return 'L';
}
return 0; //can continue
}

u08 delta_ckeck(u08 percent) {
u08 samples, steep;
if (timer_renew(&timer, 250)) { //sample voltage every 250ms
  //normal or slow charge
  if (battery_get_speedfactor() > SPEED_MEDIUMFAST_THRESOLD) {
    steep = 4;
    samples = 180;
  } else {
    steep = 6; //on a fast charge,  the voltage has to rise faster too.
    samples = 120;
  }
  return deltaStep(get_outputvoltage(), percent, samples, steep,
                   battery_get_cells());
}
return 0;
}
