/* tools.c
Some small helper functions

Copyright (C) 2007 by Malte Marwedel

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  US
*/

#include "main.h"

/* Does a 32 bit multiplication and division with 16 bit values*/
u16 multiplyanddivide(u16 data, u16 multiplier, u16 divider) {
u32 res;
u16 res2;
res = ((u32)data)*((u32)multiplier)/((u32)divider);
if (res > 0xffff) {
  res2 = 0xffff;
} else
  res2 = res;
return res2;
}

u16 min(u16 a, u16 b) {
if (b < a)
  a = b;
return a;
}

u16 max(u16 a, u16 b) {
if (b > a)
  a = b;
return a;
}

u08 hextobin(u08 hex) {
//for simplicy only upper letters for hexadecimal are converted correctly
hex -= 48;
if (hex >= 10)
  hex -= 7;
return hex;
}

u08 bintohex(u08 bin) {
if (bin >= 10)
  bin += 7;
bin += 48;
return bin;
}

void wordtostr(u08 *s, u16 number, u08 digits, u08 strposition) {
//converts a unsigned 16 bit number to a string at the base of 10.
s += strposition;
while (digits > 0) {
  digits--;
  *(s+digits) = number%10+48;
  number /= 10;
}
}

/*
In theory this function should be faster and smaller than the one with two
divisions above.
In practice this function needs 10 bytes more flash with gcc 3.4
If you use gcc 4.1 this saves in fact two bytes compared with the function above
*/

/*
void wordtostr(u08 *s, u16 number, u08 digits, u08 strposition) {
//converts a unsigned 16 bit number to a string at the base of 10.
s += strposition;
udiv_t val;
val.quot = number;
while (digits > 0) {
  digits--;
  val = udiv(val.quot, 10);
  *(s+digits) = val.rem+48;
}
}
*/
