package control;

/* Charge Control Version 1.1 (c) 2008 by Malte Marwedel

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/**
 * This class implements the singleton pattern
 */

import java.util.ArrayList;
import java.util.Enumeration;

import view.ShowMessage;

import gnu.io.*;

public class SerialIO {

	private static SerialIO sio;
	
	private SerialThread st;
	
	public static final int PORT_CLOSED = 0;
	public static final int PORT_OPEN = 1;	
	
	private int portState = PORT_CLOSED;
	
	private SerialPort serialPort; 
	
	public static SerialIO getInstance() {
		if (sio == null) {
			sio = new SerialIO();
		}
		return sio;
	}
	
	private SerialIO() {
		st = SerialThread.getInstance();
	}
	
	//The code is based on: http://en.wikibooks.org/wiki/Serial_Programming:Serial_Java#Finding_the_desired_serial_Port
	@SuppressWarnings("unchecked")
	public String[] getAvariableSerialPorts() {
	  Enumeration<CommPortIdentifier> pi = (Enumeration<CommPortIdentifier>)CommPortIdentifier.getPortIdentifiers();
	  ArrayList<CommPortIdentifier> al = new ArrayList<CommPortIdentifier>();
	  while (pi.hasMoreElements()) {
	    CommPortIdentifier pid = (CommPortIdentifier) pi.nextElement();
	    if (pid.getPortType() == CommPortIdentifier.PORT_SERIAL ) { 
	      al.add(pid);
	    }
	  }
    String[] portnames = new String[al.size()];   
    for (int i = 0; i < al.size(); i++) {
      portnames[i] = new String(al.get(i).getName().trim());
    }
	return portnames;
	}
	
	public void portOpen(String portName) {
		CommPortIdentifier portIdentifier;
    try {
	    portIdentifier = CommPortIdentifier.getPortIdentifier(portName);
    } catch (NoSuchPortException e) {
	    e.printStackTrace();    	
    	new ShowMessage("Error: There is no serial port with the name '"+portName+"'");
	    return;
    }
		try {
	    serialPort = (SerialPort)portIdentifier.open("Charger",1500);
    } catch (PortInUseException e) {
	    e.printStackTrace();
    	new ShowMessage("Error: The port '"+portName+"' is already in use and can not be opened");
	    return;
    }
		portState = PORT_OPEN;
		serialPort.setInputBufferSize(256);
		serialPort.setOutputBufferSize(256);	
		try {
	    serialPort.setSerialPortParams(9600, SerialPort.DATABITS_8 , SerialPort.STOPBITS_1, SerialPort.FLOWCONTROL_NONE);
    } catch (UnsupportedCommOperationException e) {
    	serialPort.close();
    	new ShowMessage("Error: The port '"+portName+"' can not handle the needed port parameters, closing port.");
    	return;
    }
		//System.out.println("Comm Port buffer size input: "+serialPort.getInputBufferSize()+" output: "+serialPort.getOutputBufferSize());
		st.start(serialPort);
	}
	
	public void portClose() {
		st.stop();
		serialPort.close();
		SerialToSession.getInstance().stop();
		portState = PORT_CLOSED;
	}

	public int getPortState() {
  	return portState;
  }
	
	
}
