package data;

/* Charge Control Version 1.1 (c) 2008 by Malte Marwedel

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

import control.Tools;

public class DataEntry {

	
	private int mode;
	private int voltage;
	private int current;
	private int power; //otherwise there is a resolution loss if using averaging
	
	/**
	 *  The format is:
	 * "I:X;YYYYY;ZZZZ
	 * X: The mode of operation. 1: Probing, 2: Charging, 3: Discharging
	 * Y: The voltage in mV
	 * Z: The current in mA
	 * @param str see above
	 */
	public DataEntry(String str) {
		if (str.length() == 14) {
      mode = Integer.valueOf(str.substring(2, 3));
      voltage = Integer.valueOf(str.substring(4, 9));
      current = Integer.valueOf(str.substring(10, 14));
      power = current*voltage/1000;
		} else
			System.out.println("Could understand dataline '"+str+ "' length mismatch");
	}
    
    public DataEntry(int mode, int voltage, int current, int power) {
      this.mode = mode;
      this.voltage = voltage;
      this.current = current;
      this.power = power;
    }
	
	public String getAsString() {
		return new String("I:"+mode+";"+Tools.intToStr(voltage, 5)+";"+Tools.intToStr(current, 4));
	}

	public int getCurrent() {
		return current;
	}

	public int getMode() {
		return mode;
	}

	public int getVoltage() {
		return voltage;
	}
	
	public int getPower() {
		return power;
	}

}
