package view;

/* Charge Control Version 1.1 (c) 2008 by Malte Marwedel

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

import javax.swing.filechooser.FileFilter;

import java.io.File;
import java.util.Locale;

import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;

import model.MyFileFilter;

public class ChooseFile {

  private File file; 
  
  public static final int OPEN = 1;
  public static final int SAVE = 2;
  
  /**
   * Provides a dialog for selecting a file for opening or saving.
   * If the file for saving exists already, the user get asked if he wants to overwrite it.
   * @param ending File type which are shown (example: ".txt") 
   * @param type OPEN = 1, SAVE = 2
   * @param startFolder Folder the user starts in, may be set to null
   * @param startFile File which should be selected by default, may be set to null
   */
  public ChooseFile(String ending, int type, String startFolder, String startFile) {
    //Sets the look and feel to the metal version because the file selection menu is nicer than the gtk one.
    LookAndFeel laf = UIManager.getLookAndFeel();
    try {    
      UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
    } catch (Exception e) {
      System.out.println("view.ChooseFile: Warning, could not set LookAndFeel to javax.swing.plaf.metal.MetalLookAndFeel");
    }
    JFileChooser jfc = new JFileChooser(); 
    jfc.setLocale(Locale.getDefault());
    jfc.updateUI();
    FileFilter ff = new MyFileFilter(ending);
    jfc.addChoosableFileFilter(ff);
    jfc.setFileFilter(ff);
    if (startFolder != null)
    	jfc.setCurrentDirectory(new File(startFolder));
    if (startFile != null) {
    	jfc.setSelectedFile(new File(startFile));
    	
    }
    int result = JFileChooser.ERROR_OPTION;
    if (type == OPEN) {
      result = jfc.showOpenDialog(new JFrame());
    } else
    if (type == SAVE) {
    	boolean newChoice;
    	do { // repeat the dialog box until the user selected a file to write or pressed abort
    		newChoice = false;
    		result = jfc.showSaveDialog(new JFrame());
    		if (result == JFileChooser.APPROVE_OPTION ) {
    			if (jfc.getSelectedFile().exists()) { //ask the user if he wants to overwrite
    				int agreed = JOptionPane.showConfirmDialog(null,
    						"The selected file \n\r" +jfc.getSelectedFile()+
    						"\n\rdoes already exists. Overwrite?", "File exists",
    						JOptionPane.YES_NO_OPTION, JOptionPane.QUESTION_MESSAGE);
    				if (agreed != JOptionPane.YES_OPTION) {
    					newChoice = true;
    				}
    			}
    		}
    	} while (newChoice);
    } else
      System.out.println("view.ChooseFile: Error: Unknown operation given");   
    //Set look and feel back to the previous settings.
    try {
      UIManager.setLookAndFeel(laf);
    } catch (Exception e) {
      System.out.println("view.ChooseFile: Warning, could not set LookAndFeel back to "+laf.getName());
    }
    if (result == JFileChooser.APPROVE_OPTION ) {
      file = jfc.getSelectedFile();
    }
    
  }
  
  public String getFilename() {
    if (file != null) {
      return file.toString();
    } 
    return null;
  }
  
  public File getFile() {
    return file;
  }
  
  public String getDirectory() {
  	if (file == null) {
  		return null;
  	}
  	return file.getParent();
  	
  }
  
  
}
