package view;

/* Charge Control Version 1.1 (c) 2008 by Malte Marwedel

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;

import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

/**
 * This class provides a GUI for advanced statistics and a user commentary.
 * Please note: Even if this class is in the view package, the separation between
 * view and data is violated here a little bit because the user commentary is ONLY
 * read out from the JTextArea used in this class. The benefit is that on reading
 * always the text of the JTextArea (for saving the Record in a file) no decision
 * has to be made if some internal copy or (modified) commentary has to be saved back.
 * So no flags "userChangedCommentary" and listeners registering changes at
 * the JTextField are needed.     
 * 
 * @author Malte Marwedel
 *
 */
public class RecordInfo implements ActionListener, ComponentListener {

	private JFrame frame;
	private JPanel panelmain;
  private JScrollPane scrollinfo; 
  private JScrollPane scrollcomment;
  private JTextArea edinfo;
  private JTextArea edcomment;
  private JLabel lcomment;
  private JLabel lri;
  private JButton bclose;
	private String userComment;
	
	public RecordInfo() {
    //Create and set the window
    frame = new JFrame("Record statistics");
    frame.addComponentListener(this);
    //Generate the Layout
    panelmain = new JPanel();
    panelmain.setLayout(null);
    //add components
    lri = new JLabel("Record information:");
    edinfo = new JTextArea();
    edinfo.setEditable(false);
    edinfo.setAutoscrolls(true);
    scrollinfo = new JScrollPane(edinfo);
    scrollinfo.setAutoscrolls(true);
    lcomment = new JLabel("Your notes for the record:");
    edcomment = new JTextArea();
    edcomment.setEditable(true);
    edcomment.setAutoscrolls(true);
    userComment = new String("");
    edcomment.setText(userComment);
    scrollcomment = new JScrollPane(edcomment);
    scrollcomment.setAutoscrolls(true);
    bclose = new JButton("Close");
    bclose.setActionCommand("close");
    bclose.addActionListener(this);
    panelmain.add(lri);
    panelmain.add(scrollinfo);
    panelmain.add(lcomment);
    panelmain.add(scrollcomment);
    panelmain.add(bclose);
    frame.add(panelmain);
    frame.pack();
    frame.setSize(550, 500);
    frame.setLocation(380, 0);
	}
	
  public void resize() {
  	int sizex = frame.getWidth();
    int sizey = frame.getHeight()-30; //30 pixel for the window header
    sizey = Math.max(sizey, 170);
    sizex = Math.max(sizex, 30);
    int sizeyinfo = (sizey-150)*2/3;
    int sizeycomment = (sizey-150)/3;
    lri.setBounds(10, 10, sizex-30, 30);
    scrollinfo.setBounds(10, 45, sizex-30, sizeyinfo);
    edinfo.setBounds(0, 0, sizex-30,  sizeyinfo);
    lcomment.setBounds(10, sizeyinfo+55, sizex-30, 30);
    scrollcomment.setBounds(10, sizeyinfo+90, sizex-30, sizeycomment);
    edcomment.setBounds(0, 0, sizex-30, sizeycomment);
    bclose.setBounds(10, sizey-40, sizex-30, 30);
    panelmain.updateUI();
  }
	
	public void show() {
		frame.setVisible(true);
	}

	public void componentHidden(ComponentEvent e) {
		//ignoring
	}

	public void componentMoved(ComponentEvent e) {
		//ignoring
	}

	public void componentResized(ComponentEvent e) {
		resize();
	}

	public void componentShown(ComponentEvent e) {
		//ignoring
	}

	public void actionPerformed(ActionEvent e) {
		if (e.getActionCommand().equals("close")) {
			setInvisible();
		}
	}
	
	public void setInvisible() {
		frame.setVisible(false);
	}

	public void setUserComment(String str) {
		edcomment.setText(str);
		userComment = str; //needed to detect changes
	}
	
	public String getUserComment() {
		return edcomment.getText();
	}
	
	public void setStatisticText(String text) {
		edinfo.setText(text);
	}
	
	public void setFilename(String fname) {
		frame.setTitle("Record statistics - "+fname);
	}
	
	public boolean isModified() {
		if (edcomment.getText().equals(userComment)) {
			return false;
		}
		return true;
	}
	
	public void markSaved() {
		userComment = edcomment.getText();
	}
	
}
