/* tools.h

Header file for tools.c

Copyright (C) 2007 by Malte Marwedel

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  US
*/

#ifndef TOOLS_H
  #define TOOLS_H

u16 multiplyanddivide(u16 data, u16 multiplier, u16 divider);
u16 min(u16 a, u16 b);
u16 max(u16 a, u16 b);
u08 hextobin(u08 hex);
u08 bintohex(u08 bin);
void wordtostr(u08 *s, u16 number, u08 digits, u08 strposition);

static inline unsigned char swap (unsigned char x) {
asm volatile ("swap %0" : "=r" (x) : "0" (x));
return x;
}


/*The udiv_t struct and udiv() function are similar to those div_t and div() in
  the avr-libc but use unsigned values instead of those in the library.
Thanks to
http://www.roboternetz.de/wissen/index.php/Avr-gcc#libgcc2_verwenden
to show me how udiv() could be implemented.
*/

typedef struct {
  uint16_t quot;
  uint16_t rem;
} udiv_t;

extern udiv_t udiv(uint16_t num, uint16_t denom) __asm__("__udivmodhi4");

#endif

