/*Basic A/D Libray
  Version 1.2
  (c) 2005, 2008 by Malte Marwedel
  www.marwedels.de/malte


  This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/
#ifndef BASICAD_H
 #define BASICAD_H

#include <avr/io.h>
#include <inttypes.h>

uint16_t getadc(uint8_t channel);
uint16_t sample_ad(uint8_t channel, uint8_t samples);
uint16_t samle_adQuartil(uint8_t channel);

static __inline__ void ad_init(uint8_t prescal) {
/* ADEN: Activate converter
   ADSC: Start first A/D conversion
   prescal->ADPS0..ADPS2:
   prescal: divider:
   0        2
   1        2
   2        4
   3        8
   4        16
   5        32
   6        64
   7        128
   It is reccommend to use a frequency between 50 und 200khz for a 10 Bit
resolution.
   */
	ADMUX = (1<<REFS0) | 0; //Select AD channel
	ADCSRA = (1 << ADEN) | (1<< ADSC) | (prescal & 0x07);
	//Wait until first conversion is complete
}

#endif
