
#include "main.h"
#include <stdio.h>
#include "gui.h"

#define BAUDRATE 19200
#define UARTNUMBER (F_CPU/(BAUDRATE*16l)-1)

#define UNUSED(x) (void)(x)

/*If the RX pin is not connected, there is sometimes garbage in the buffer,
  which is in some cases detected as valid input. So by requireing a special
  char fist, this disables these false positives.
  NOTE: Input is for debug only and does not work with L measurement.
*/

uint8_t g_inputEnabled = 0;

int uart_put(char var, FILE *stream) {
	UNUSED(stream);
	while (!(UCSR0A & (1<<UDRE0)));
	UDR0 = var;
	return 0;
}

void uart_init(void) {
	//pullup prevents detecting noise as data when pin is not connected
	PORTD |= (1<<PD0); //RX pullup
	UBRR0L = UARTNUMBER; //set speed
	UCSR0C = (1<<UCSZ01) | (1<<UCSZ00); //set 8Bit mode
	UCSR0B = 1<<RXEN0 | 1<<TXEN0;	//TX enabled, RX enabled
	static FILE mystdout = FDEV_SETUP_STREAM(uart_put, NULL, _FDEV_SETUP_WRITE);
	stdout = &mystdout;
}

uint8_t rs232_key(void) {
	if (UCSR0A & (1<<RXC0)) {
		uint8_t d = UDR0;
		if (g_inputEnabled) {
			if ((d >= '1') && (d <= '6')) {
				return (d - '0');
			}
			if (d == 'P') { //bootloader will send 'P', so easy flashig without power off/on
				lcdPutsP(PSTR("!Resetting...\r\n"));
				while(1); //watchdog will do it
			}
		}
		if (d == 'h') {
			printf_P(PSTR("LCRD Meter.\r\n1-6: Key input\r\nP: Reset\r\ne: Enable key input\r\nh: This text\r\n"));
			return 0;
		}
		if (d == 'e') { //part of the Peda password
			g_inputEnabled = 6; //the bootloader password is 6 chars, so there will be 5 invalid.
			return 0;
		}
		if (g_inputEnabled) {
			printf_P(PSTR("False input? %i\r\n"), d);
			g_inputEnabled--;
			if (g_inputEnabled == 0) {
				printf_P(PSTR("Input disabled\r\n"));
			}
		}
	}
	return 0;
}

