/*
Give out a clock on PB3 (connected to XTAL1 on other AVRs)
Tests show that the output frequency is approx 320kHz.
Dont forget to disable the divider by 8 on the tiny13 (source chip).

With a divider of 8 programmed in the target chip, you might end up at 40kHz.
So you might need to slow down the programming speed.
*/

#define F_CPU 9600000

#include <avr/io.h>

int main(void) {
	DDRB = 1<<PB3;
	unsigned char state = 0;
	unsigned char matrix[2] = {0, 1<<PB3};
	/*try to get an equal time for high and low period. Therefore the code is
	 without branches within the loop */
	for (;;) {
		PORTB = matrix[state];
		state = 1 - state;
   }
}
