#include <stdlib.h>
#include <stdio.h>

#include <strings.h>
#include <unistd.h>

#include "simplers232.h"

int main(int argc, char ** argv) {
	int error = 0;
	if (argc != 3) {
		printf("YASAP-linux V1.0 (c) 2015 by Malte Marwedel\r\n");
		printf("Usage: SERIALDEVICE BINARYFILE\r\n");
		return 1;
	}
	int fdrs232 = serial_open(argv[1]);
	if (fdrs232 <= 0) {
		return 1;
	}
	serial_speed(B19200);
	FILE * f = fopen(argv[2], "rb");
	if (f) {
		printf("Programming...\r\n");
		serial_clear();
		serial_put("p");
		unsigned char b;
		size_t bread = 0;
		char bufferOut[32];
		int byteswritten = 0;
		int pagepaddingbytes = 0;
		int answer;
		sleep(1);	//wait for flash erase + info messages
		serial_clear(); //clear info messages
		while (1) {
			bread = fread(&b, 1, 1, f);
			if (bread != 1) {
				break;
			}
			sprintf(bufferOut, "%02X", b);
			if (serial_put(bufferOut) != 0) {
				printf("Write error - abort\r\n");
				error = 1;
				break;
			}
			byteswritten++;
			if ((byteswritten % 100) == 0) {
				printf("#");
			}
			answer = serial_get();
			if (answer < 2) {
				printf("No answer from programmer - abort\r\n");
				error = 1;
				break;
			}
			if (answer > 2) {
				//20ms -> not working, 40 -> working, select 80 to be sure
				usleep(80000); //wait for page to be programmed
			}
		}
		if (!error) {
			printf("\r\nFinishing...\r\n");
			//fill until page end, then terminate
			while(1) {
				if (index(rs232recbuf, '-')) {
					break;
				}
				serial_put("FF");
				pagepaddingbytes++;
				if (serial_get() <= 0) {
					printf("No answer from programmer - abort\r\n");
					error = 1;
					break;
				}
			}
		}
		serial_put("x"); //always try to get out of prog mode!
		printf("Written bytes: %i, padded: %i, total: %i\r\n", byteswritten, pagepaddingbytes, byteswritten + pagepaddingbytes);
	} else {
		printf("Could not open %s\r\n", argv[2]);
		serial_close();
		return 1;
	}
	fclose(f);
	serial_close();
	if (!error) {
		return 0;
	}
	return 1;
}
