// Header Datei fr main.c
#ifndef MAIN_H
 #define MAIN_H

#include <avr/io.h>
#include <avr/interrupt.h>
#include <avr/signal.h>
#include <avr/pgmspace.h>
#include <stdlib.h>
#include "stepper.h"
#include "driverecord.h"

#define uchar unsigned char
#define uint unsigned int

#define xRC5_IN  PIND
#define xRC5  PD1   // IR input low active

#define XTAL  4.0000e6


/*Belegung der Roboter Funktionen bei welchem RC5 Code welche
  Funktion ausgefhrt wird. Mglicherweise unterscheidet sich diese von
  Fernbedienung zu Fernbedienung! Daher habe ich die Belegung erstmal mit
  Fragezeichen versehen. Die Zuordnung muss daher je nach Bedarf an
  die eigene Fernbedieung angepasst werden.
*/

//16 = ? Volume + ?
#define drive_forward 16
//17 = ? Volume - ?
#define drive_backward 17
//22 = ? Bass + ?
#define drive_right 22
//21 = ? Farbe - ?
#define drive_left 21
//43 = ? Record/rote Taste ?
#define recmode_record 43
//46 = ? Play/blaue Taste ?
#define recmode_play 46
//45 = ? Stop/gelbe Taste ?
#define recmode_stop 45
//56 = ? AV Eingnge auswhlen ?
#define wall_driveback 56
//35 = ? Mono/Stereo Umschalten ?
#define wall_driveaway 35
//15 = ? Uhrzeit und Programmname + Nummer einblenden ?
#define wall_follow 15


//in rc5.c
extern uint volatile rc5_data;    // store result

//in main.c
extern uint8_t wheel_max_l;
extern uint8_t wheel_max_r;
extern uint8_t wheel_speed_l;
extern uint8_t wheel_speed_r;
extern uint8_t wheel_direction_l;
extern uint8_t wheel_direction_r;

extern uint8_t wall_mode;
extern uint8_t wall_act_state;

//Timer Variablen
extern uint8_t volatile count_longperiod;
extern uint8_t volatile count_motor_stop;
extern uint8_t volatile count_gear;
extern uint8_t volatile count_wheel_l;
extern uint8_t volatile count_wheel_r;
extern uint16_t volatile count_recording;
extern uint8_t volatile count_wall_act;

SIGNAL (SIG_OVERFLOW1);
uint8_t min(uint8_t a, uint8_t b);
void wall_reaction(void);
int main( void );
void speedcontrol(void);
void calculatewheels(void);

#endif
