/** Enthaelt eine komplette Welt mit allen Lebewesen und der Weltgroesse sowie
    des Zyklus und der fortlaufenden Hasen/Woelfe IDs.
    Also alles was sich waehrend eines Zyklus aendert*/

/*
    Copyright (C) 2006 by Malte Marwedel    m.marwedel < AT > onlinehome.de

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

package World;

import Zelle.*;


public class World {

  private int sizex; //Groesse der Welt in x Richtung
  private int sizey; //Groesse der Welt in y Richtung
  private boolean init_done = false; //Ob make() schon aufgerufen wurde

  /* Fortlaufende Nummer der Hasen und Woelfe. Fuer Statistiken nuetzlich */
  private int hase_current_id = 0;
  private int wolf_current_id = 0;

  private int cycle = 0; //Aktuelle Zyklus

  private Zelle[][] surface; //Das eigentliche Spielfeld

  public World exact_clone() { //Erzeugt eine exakte Kopie der Welt
    World w2 = new World();
    w2.sizex = this.sizex;
    w2.sizey = this.sizey;
    w2.init_done = this.init_done;
    w2.hase_current_id = this.hase_current_id;
    w2.wolf_current_id = this.wolf_current_id;
    w2.cycle = this.cycle;
    w2.surface = new Zelle[w2.sizex][w2.sizey];
    for (int nx = 0; nx < w2.sizex; nx++) {
      for (int ny = 0; ny < w2.sizey; ny++) {
        w2.surface[nx][ny] = this.surface[nx][ny].exact_clone();
      }
    }
    return w2;
  }

  private void make_sub(int n_sizex, int n_sizey) {
    //Gemeinsame Unterfunktion von make() und adapt()
    if (!this.init_done) {
      if ((n_sizex > 0) && (n_sizey > 0)) {
        this.sizex = n_sizex;
        this.sizey = n_sizey;
        this.surface = new Zelle[n_sizex][n_sizey];
        this.init_done = true;
      } else {
        System.out.println("World.make: Error: n_sizex and n_sizey must be greater than zero");
      }
    } else {
      System.out.println("World.make: Error: make() can be run only once");
    }
  }

  public void make(int n_sizex, int n_sizey) {
    //Initialisierung aller wichtigen Variablen
    this.make_sub(n_sizex,n_sizey);
    this.hase_current_id = 0;
    this.wolf_current_id = 0;
    this.cycle = 0;
  }

  public void adapt(World old_world) {
    //Wie make(), uebernimmt jedoch Werte einer alten Welt soweit sinnvoll
    this.make_sub(old_world.sizex_get(), old_world.sizey_get());
    this.hase_current_id = old_world.hase_current_id_get();
    this.wolf_current_id = old_world.wolf_current_id_get();
    this.cycle = old_world.cycle_get() +1;
  }

  public int sizex_get() { //Groesse des Spielfeldes in x Richtung
    return this.sizex;
  }

  public int sizey_get() { //Groesse des Spielfeldes in y Richtung
    return this.sizey;
  }

  public void zelle_set(int posx, int posy, Zelle n_zelle) {
    //Setzt eine Zelle der Welt
    if (this.init_done) {
      if ((posx < this.sizex) && (posy < this.sizey) && (posx >= 0) &&
         (posy >= 0)) {
        this.surface[posx][posy] = n_zelle;
      } else {
        System.out.println("World.zelle_set: Error: posx, posy out of range");
      }
    } else {
      System.out.println("World.zelle_set: Error: Run make() first");
    }
  }

  public Zelle zelle_get(int posx, int posy) {
    //Gibt eine Zelle des Spielfeldes zurueck
    if (this.init_done) {
      if ((posx < this.sizex) && (posy < this.sizey) && (posx >= 0) &&
         (posy >= 0)) {
        return this.surface[posx][posy];
      } else {
        System.out.println("World.zelle_get: Error: out of range. posx: "+posx+" , posy: "+posy);
        return null;
      }
    } else {
      System.out.println("World.zelle_get: Error: Run make() first");
      return null;
    }
  }


  public int hase_current_id_get() { //Die ID des juengsten Hasen
    return hase_current_id;
  }

  public int hase_id_new_get() { //ID fuer neuen Hasen erzeugen
    hase_current_id++;
    return hase_current_id;
  }

  public int wolf_current_id_get() { //Die ID des juengsten Wolfs
    return wolf_current_id;
  }

  public int wolf_id_new_get() { //ID fuer neuen Wolf erzeugen
    wolf_current_id++;
    return wolf_current_id;
  }

  public int cycle_get() { //Aktueller Zyklus der Welt
    return this.cycle;
  }

  public int tier_typ_count(int tiertyp) {
    //Wieviele Tiere vom Typ tiertyp auf der Welt leben ermitteln
    int no = 0;
    for (int nx = 0; nx < sizex;nx++) {
      for(int ny = 0; ny < sizey;ny++) {
        no += surface[nx][ny].tier_typ_count(tiertyp);
      }
    }
    return no;
  }

}
