/** Funktionen zur Modifizierung von Welten. Es werden keine Werte
    in dieser Klasse gespeichert. Daher static problemlos */

/*
    Copyright (C) 2006 by Malte Marwedel    m.marwedel < AT > onlinehome.de

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

package Worldaction;

import World.*;
import Zelle.*;
import Tier.*;
import Settings.*;

public class Worldaction {

  public static World world_new(Settings config, int sizex, int sizey) {
    //Initialisiert eine Neue Welt mit allem Drum und Dran.
    long st = System.currentTimeMillis();
    int newhasen = config.hase_start_num_get();
    int newwoelfe = config.wolf_start_num_get();
    if (sizex*sizey <= newhasen) {
      //Wir brauchen mindestens ein freies Feld fuer die Woelfe!
      System.out.println("Worldaction.world_new: Error: More bunnies than cells on new world creating not possible");
      return null;
    }
    //Erzeugt eine neue Welt basierend auf den Config Werten
    World w1 = new World();
    w1.make(sizex,sizey);
    //Initialisieren der Zellen (mit den gleichen Werten)
    for (int nx = 0; nx < sizex; nx++) {
      for (int ny = 0; ny < sizey; ny++) {
        Zelle z1 = new Zelle();
        z1.make(0,'G', config.grass_max_zelle_get());
        w1.zelle_set(nx,ny,z1);
      }
    }
    //Erzeugen der Hasen
    for (int n = 0; n < newhasen; n++) {
      /* Da Math.random auch glatt 1 liefern koente muss durch das abziehen von
         einem winzigem Betrag verhindert werden, dass px oder py gleich sizex
         oder sizey ist.
      */
      int px = (int)((sizex-0.0000001)*Math.random());
      int py = (int)((sizey-0.0000001)*Math.random());
      Tier t1 = new Tier();
      t1.make(w1.hase_id_new_get(),2);
      Zelle z2 = new Zelle();
      z2 = w1.zelle_get(px,py);
      z2.tier_add(t1);
      w1.zelle_set(px,py,z2);
      //System.out.println("Hase set at: "+px+","+py);
    }
    //System.out.println("blah: "+w1.zelle_get(25,25).contains(2));;
    //Erzeugen der Woelfe
    for (int n = 0; n < newwoelfe; n++) {
      /* Da Math.random auch glatt 1 liefern koente muss durch das abziehen von
         einem winzigem Betrag verhindert werden, dass px oder py gleich sizex
         oder sizey ist.

         Sollte auf einem Feld bereits Hasen sein, so wird solange nach rechts
         gegangen bis ein Hasenfreies Feld gefunden wurde.
      */
      int px = (int)((sizex-0.0000001)*Math.random());
      int py = (int)((sizey-0.0000001)*Math.random());
      while (w1.zelle_get(px,py).contains(2)) { //Solange Hasen enthalten sind
      /* Suche neues Feld ohne Hasen. Da weniger Hasen als Felder muss
         mindestens ein Feld ohne Hasen sein */
        px++;
        if (px == sizex){
          px = 0;
          py++;
        }
        if (py == sizey) {
          py = 0;
        }
        //System.out.println("Hase present, try "+px+","+py+"  "+w1.zelle_get(px,py).contains(2));
      }
      Tier t1 = new Tier();
      t1.make(w1.wolf_id_new_get(),1);
      Zelle z2 = new Zelle();
      z2 = w1.zelle_get(px,py);
      z2.tier_add(t1);
      w1.zelle_set(px,py,z2);
    }
  System.out.println("Worldaction.world_new: Hint: Needed "+(System.currentTimeMillis()-st)+" milliseconds");
  return w1;
  }

  public static World world_cycle(World oldworld, Settings config) {
    /*Zuerst wird die Bewegungsrichtig aller Tiere in der alten Welt
     festgesetzt, das Alter erhoet, der Hunger erhoet und bei allen Hasen
     wird festgelegt ob sie Kinder bekommen.
   */
    oldworld = tiere_move(oldworld,config);
    //Basierend auf diesen Informationen wird eine neue Welt erzeugt und die
    //Tiere auf die Welt kopiert
    long st = System.currentTimeMillis();
    World newworld = new World();
    newworld.adapt(oldworld);
    int sizex = newworld.sizex_get();
    int sizey = newworld.sizey_get();
    for(int nx = 0; nx < sizex; nx++) {
      for (int ny = 0; ny < sizey; ny++) {
        Zelle z_new = new Zelle();
        //Tiere Bewegen
        z_new = in_new_world(oldworld,config,z_new,nx,ny);
        //Auf Feldern mit Hasen + Woefen werden die Hasen entfernt und Junge
        //fuer die Woefe festgelegt
        z_new = wolf_eat(config,z_new);
        //Zelle in neuer Welt speichern
        newworld.zelle_set(nx,ny,z_new);
      }
    }
    System.out.println("Worldaction.world_cycle: Hint: Part of this function needed "+
                       (System.currentTimeMillis()-st)+" milliseconds");
    /*Alle Tiere bekommen ihre Jungen
      kann nicht in der obigen Schleife erfolgen, da das Tier-limmit
      beruecksichtigt werden muss, welches erst feststeht wenn alle Woelfe
      gegessen haben */
    newworld = tiere_nachwuchs(newworld,config);
    return newworld;
  }

  private static World tiere_nachwuchs(World newworld, Settings config) {
    //Alle Tiere bekommen ihre Kinder auf dem Feld auf dem sie selber sind.
    //Fixme: Ab 50000 Tiere sehr langsam. Ab 400000 Tiere unbenutzbar lahm.
    long st = System.currentTimeMillis();
    int curr_wolf = newworld.tier_typ_count(1);
    int curr_hase = newworld.tier_typ_count(2);
    int sizex = newworld.sizex_get();
    int sizey = newworld.sizey_get();
    //nur bei strict_max_num == false:
    //wenn q_limmit < 1, so nimmt die Wahrscheinlichkeit eines Kindes ab
    float hase_child_q_limmit;
    if (config.hase_max_num_get() < curr_hase) {
      hase_child_q_limmit = ((float)config.hase_max_num_get())/ ((float)curr_hase);
    } else
      hase_child_q_limmit = (float)1.01;
    float wolf_child_q_limmit;
    if (config.wolf_max_num_get() < curr_wolf) {
      wolf_child_q_limmit = ((float)config.wolf_max_num_get()) /((float)curr_wolf);
    } else
      wolf_child_q_limmit = (float)1.01;
    //System.out.println("Q Lim Wolf: "+wolf_child_q_limmit+" Hase: "+hase_child_q_limmit);
    for(int nx = 0; nx < sizex; nx++) {
      for (int ny = 0; ny < sizey; ny++) {
        Zelle z_new = new Zelle();
        z_new = newworld.zelle_get(nx,ny);
        for (int n = 0; n < z_new.length(); n++) { //Tiere Bearbeiten
          Tier t1 = new Tier();
          t1 = z_new.tier_get(n);
          if (t1 != null) { //Wenn Tier an Zellenstelle
            if (t1.child_get()) { //Wenn auch noch Kind bekommt
              Tier t2 = new Tier();
              if (t1.type_get() == 1) { //Wolf
                t2.make(newworld.wolf_id_new_get(),1);
                 if ((curr_wolf < config.wolf_max_num_get()) ||
                      ((!config.strict_max_num_get()) &&
                       (wolf_child_q_limmit > Math.random()))) {
                   curr_wolf++;
                   z_new.tier_add(t2); //Kind in Zelle einfuegen
                 }
               } else
               if (t1.type_get() == 2) { //Hase
                 t2.make(newworld.hase_id_new_get(),2);
                 if ((curr_hase < config.hase_max_num_get()) ||
                      ((!config.strict_max_num_get()) &&
                       (hase_child_q_limmit > Math.random()))) {
                   curr_hase++;
                   z_new.tier_add(t2); //Kind in Zellen einfuegen
                 }
               } else
                 System.out.println("Worldaction.tiere_nachwuchs: Error: Unknown type of animal");
               //Fixme: Gene der Eltern mit uebernehmen
             } //Ende Kind bekommen
           } //Ende ist Tier
        } //Ende Zelle durchgehen
        newworld.zelle_set(nx,ny,z_new); //Zelle in neue Welt
      }
    }
    System.out.println("Worldaction.tiere_nachwuchs: Hint: Needed "+
                       (System.currentTimeMillis()-st)+" milliseconds");
    return newworld;
  }

  private static Zelle wolf_eat(Settings config, Zelle z_new) {
    //Wenn in einer Zelle Woelfe und Hasen, so werden alle Hasen entfernt und
    //alle Woelfe erwarten mit einer gewissen Wahrscheinlichkeit ein Kind
    if ((z_new.contains(1)) && z_new.contains(2)) { //Woefe + Hasen vorhanden
      if (!config.hase_fight_wolf_get()) { //Hasen koennen Wolfe nicht besiegen
        if (!config.wolf_complex_food_get()) { //Einfache essen Modell
          for (int n = 0; n < z_new.length(); n++) { //Gehe durch die Zelle
            Tier t1 = new Tier();
            t1 = z_new.tier_get(n);
            if (t1 != null) { //Wenn nicht leer
              if (t1.type_get() == 1) { //Wenn Wolf
                float possible = ((float)(config.wolf_nachwuchs_get()))/100; //0..1
                float rand = (float)(Math.random()); //0..1
                if (rand < possible) {
                  t1.child_set(true); //Erwartet Kind
                }
              }
              if (t1.type_get() == 2) { //Wenn Hase
                //System.out.println("Hase was eaten by wolf");
                t1 = null; //Aufgegessen
              }
              z_new.tier_set(n,t1);
            }
          }
        } else {
          System.out.println("Worldaction.wolf_eat: Error: Not implemented yet (2)");
        }
      } else {
        System.out.println("Worldaction.wolf_eat: Error: Not implemented yet (1)");
      }
    }
    return z_new;
  }


  private static Zelle zelle_west_of_get(World oldworld, Settings config,
                                         int px, int py) {
    //Die Zelle westlich von px,py wird zurueckgegeben
    px--;
    if (px < 0) {
      if (config.area_inf_get()) {
        px = oldworld.sizex_get()-1;
      } else { //Rand, gebe leere Zelle zurck
        Zelle z0 = new Zelle();
        z0.make(0,'G',0);
        return z0;
      }
    }
    Zelle z1 = new Zelle();
    z1 = oldworld.zelle_get(px,py);
    return z1;
  }

  private static Zelle zelle_east_of_get(World oldworld, Settings config,
                                         int px, int py) {
    //Die Zelle oestlich von px,py wird zurueckgegeben
    px++;
    if (px >= oldworld.sizex_get()) {
      if (config.area_inf_get()) {
        px = 0;
      } else { //Rand, gebe leere Zelle zurck
        Zelle z0 = new Zelle();
        z0.make(0,'G',0);
        return z0;
      }
    }
    Zelle z1 = new Zelle();
    z1 = oldworld.zelle_get(px,py);
    return z1;
  }

  private static Zelle zelle_north_of_get(World oldworld, Settings config,
                                         int px, int py) {
    //Die Zelle noerdlich von px,py wird zurueckgegeben
    py--;
    if (py < 0) {
      if (config.area_inf_get()) {
        py = oldworld.sizey_get()-1;
      } else { //Rand, gebe leere Zelle zurck
        Zelle z0 = new Zelle();
        z0.make(0,'G',0);
        return z0;
      }
    }
    Zelle z1 = new Zelle();
    z1 = oldworld.zelle_get(px,py);
    return z1;
  }

  private static Zelle zelle_south_of_get(World oldworld, Settings config,
                                         int px, int py) {
    //Die Zelle suedlich von px,py wird zurueckgegeben
    py++;
    if (py >= oldworld.sizey_get()) {
      if (config.area_inf_get()) {
        py = 0;
      } else { //Rand, gebe leere Zelle zurck
        Zelle z0 = new Zelle();
        z0.make(0,'G',0);
        return z0;
      }
    }
    Zelle z1 = new Zelle();
    z1 = oldworld.zelle_get(px,py);
    return z1;
  }

  private static Zelle in_new_world(World oldworld, Settings config,
                                    Zelle z_new, int nx, int ny) {
    Zelle z_center = oldworld.zelle_get(nx,ny);
    Zelle z_west = zelle_west_of_get(oldworld,config,nx,ny);
    Zelle z_east = zelle_east_of_get(oldworld,config,nx,ny);
    Zelle z_north = zelle_north_of_get(oldworld,config,nx,ny);
    Zelle z_south = zelle_south_of_get(oldworld,config,nx,ny);
    //Sch�zt die zu erwartende Anzahl der Tiere ab
    int tierno_max = (z_center.tiere_count() + z_west.tiere_count() +
                        z_east.tiere_count() + z_north.tiere_count() +
                        z_south.tiere_count());
    int tierno_guess = tierno_max / 2; //Etwas groesser als wohl noetig
    z_new.make(tierno_guess,z_center.landtype_get(),z_center.grass_get());
    //Fixme: Gras wachsen lassen
    if (tierno_max == 0) {
      //Keine Tiere gezaehlt -> brauchen auch keine Einfuegen (Optimierung)
      return z_new;
    }
    //Einfuegen aller Tiere die im westen nach osten wandern
    for (int n = 0; n < z_west.length(); n++) {
      Tier t1 = z_west.tier_get(n);
      if (t1 != null) {
        if (t1.direction_get() == 'O') {
          z_new.tier_add(t1);
        }
      }
    }
    //Einfuegen aller Tiere die im osten nach westen wandern
    for (int n = 0; n < z_east.length(); n++) {
      Tier t1 = z_east.tier_get(n);
      if (t1 != null) {
        if (t1.direction_get() == 'W') {
          z_new.tier_add(t1);
        }
      }
    }
    //Einfuegen aller Tiere die im norden nach sueden wandern
    for (int n = 0; n < z_north.length(); n++) {
     Tier t1 = z_north.tier_get(n);
      if (t1 != null) {
        if (t1.direction_get() == 'S') {
          z_new.tier_add(t1);
        }
      }
     }
     //Einfuegen aller Tiere die im sden nach norden wandern
     for (int n = 0; n < z_south.length(); n++) {
       Tier t1 = z_south.tier_get(n);
       if (t1 != null) {
         if (t1.direction_get() == 'N') {
           z_new.tier_add(t1);
         }
       }
     }
     //Einfuegen aller Tiere die sich nicht bewegen
     for (int n = 0; n < z_center.length(); n++) {
       Tier t1 = z_center.tier_get(n);
       if (t1 != null) {
         if (t1.direction_get() == 'H') {
           z_new.tier_add(t1);
         }
       }
     }
     return z_new;
   }

  private static Tier tier_move(Tier t1, Settings config, int px, int py,
                                int sizex, int sizey) {
    /*Legt die des Tiers t1 fest.
      Ist das Tier zu alt, stirb es.
      Der Hunger wird erhoeht.
      Wenn es sich um einen Hasen handelt kann dieser mit einger gewissen
      Wahrscheinlichkeit Schwanger werden */
    boolean area_inf = config.area_inf_get();
    boolean area_freefall = config.area_freefall_get();
    int type = t1.type_get();
    int verhalten = 0;
    //Bewegungsrichtung festlegen.
    if (type == 1) { //Wolf
      if (t1.age_get() >= config.wolf_alter_max_get()) { //zu alt
        t1.direction_set('D'); //Die /Down into the earth
        return t1;
      }
      verhalten = config.wolf_verhalten_get();
    } else
    if (type == 2) { //Hase
      if (t1.age_get() >= config.hase_alter_max_get()) { //zu alt
        t1.direction_set('D'); //Die /Down into the earth
        return t1;
      }
      verhalten = config.hase_verhalten_get();
    } else {
      System.out.println("Worldaction.tier_move: Error: Unknown type of animal");
      return t1;
    }
    if (verhalten == 0) { //Simples Zufallsverhalten
      float direct = (float)(5*Math.random());
      if (direct < 1) {
        t1.direction_set('N');
      } else
      if (direct < 2) {
        t1.direction_set('W');
      } else
      if (direct < 3) {
        t1.direction_set('S');
      } else
      if (direct < 4) {
        t1.direction_set('O');
      } else {
        t1.direction_set('H');
      }

    } else {
      System.out.println("Worldaction.tier_move: Error: Not implemented yet(2)");
    }
    if (!area_inf) { //Nicht Unendliche Torus-Welt
      //Falls bewegung nach aussn fuehren wuerde
      if ((t1.direction_get() == 'N') && (py == 0)) {
         if (area_freefall) {
           t1.direction_set('D');
         } else {
           t1.direction_set('S');
         }
      }
      if ((t1.direction_get() == 'S') && (py == (sizey-1))) {
         if (area_freefall) {
           t1.direction_set('D');
         } else {
           t1.direction_set('N');
         }
      }
      if ((t1.direction_get() == 'W') && (px == (sizex-1))) {
         if (area_freefall) {
           t1.direction_set('D');
         } else {
           t1.direction_set('O');
         }
      }
      if ((t1.direction_get() == 'O') && (px == 0)) {
         if (area_freefall) {
           t1.direction_set('D');
         } else {
           t1.direction_set('W');
         }
      }
    } //Ende: area_not_inf
    //Erhoehen des Alters
    t1.age_inc();
    //Hunger erhoeen
    t1.hunger_add(1);
    //Hasen bekommen Junge
    if (type == 2) { //Wenn Hase
      float possible = ((float)(config.hase_nachwuchs_get()))/100; //0..1
      float rand = (float)(Math.random()); //0..1
      if (rand < possible) {
        t1.child_set(true);
      } else {
        t1.child_set(false);
      }
    } else { //Die Woefe bekommen hier erstmal keine Kinder
      t1.child_set(false);
    }
    return t1;
  }


  private static World tiere_move(World oldworld, Settings config) {
    //Ruft tier_move() fuer jedes Tier auf der Welt auf
    long st = System.currentTimeMillis();
    int sizex = oldworld.sizex_get();
    int sizey = oldworld.sizey_get();
    for (int nx = 0; nx < sizex; nx++) {
      for (int ny = 0; ny < sizey; ny++) {
        Zelle z1 = new Zelle(); //Zelle erzeugen
        z1 = oldworld.zelle_get(nx,ny); //Zelle holen
        for (int nz = 0; nz < z1.length(); nz++) { //Zelle durchgehen
          //System.out.println("Hint: "+nx+"."+ny+":"+nz+"max:"+z1.length());
          Tier t1 = new Tier();
          t1 = z1.tier_get(nz);//Tier holen
          if (t1 != null) {
            t1 = tier_move(t1, config,nx,ny,sizex,sizey); //Tier bearbeiten
          }
          z1.tier_set(nz,t1); //Tier zurueckschreiben
        }
        oldworld.zelle_set(nx,ny,z1); //Zelle zurueckschreiben
      }
    }
    System.out.println("Worldaction.tier_move: Hint: Needed "+
                       (System.currentTimeMillis()-st)+" milliseconds");
    return oldworld;
  }
}
