/** Implementiert das Hauptfenster der Simulation */

/*
    Copyright (C) 2006 by Malte Marwedel    m.marwedel < AT > onlinehome.de

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

package Mgui;

import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
import java.awt.image.*;
import Aboutbox.*;
import Zelle.*;
import World.*;
import Settings.*;
import Worldaction.*;
import Universe.*;
import Chars.*;


public class Mgui implements ActionListener,WindowListener {

  private JFrame frame1;
  private JFrame fopt;
  private JFrame fsize;

  private Aboutbox f2 = new Aboutbox();

  private World surface;
  private World surface_orig;
  private Settings config = new Settings();
  private ImageIcon surfaceimage;
  private ImageIcon splashimage = new ImageIcon("splash1.png");
  private JLabel lsurface;
  JPanel pimage;
  JLabel lstepp;
  JLabel lwolf;
  JLabel lhase;
  JButton breset;
  JButton bnext;
  JCheckBoxMenuItem mcolors = new JCheckBoxMenuItem("Anzahl der Tiere farbig darstellen");
  String shs = new String("Anzahl der Hasen beim Start");
  JTextField ths = new JTextField("?");
  String sws = new String("Anzahl der W"+Chars.oe+"lfe beim Start");
  JTextField tws = new JTextField("?");
  String shm = new String("Anzahl der maximalen Hasen");
  JTextField thm = new JTextField("?");
  String swm = new String("Anzahl der maximalen W"+Chars.oe+"lfe");
  JTextField twm = new JTextField("?");
  String shz = new String("Lebensdauer (in Zyklen) der Hasen");
  JTextField thz = new JTextField("?");
  String swz = new String("Lebensauder (in Zyklen) der W"+Chars.oe+"lfe");
  JTextField twz = new JTextField("?");
  String shw = new String("Vermehrungswahrscheinlichkeit der Hasen in %");
  JTextField thw = new JTextField("?");
  String sww = new String("Vermehrungswahrscheinlichkeit der W"+Chars.oe+"lfe in %");
  JTextField tww = new JTextField("?");
  JCheckBox cstrictmax = new JCheckBox("Strenges Tiere Maximum");
  JCheckBox cworldinf = new JCheckBox("Unendliche Torus-Welt");
  JCheckBox cworldfreefall = new JCheckBox("Tiere k"+Chars.oe+"nnen von der Welt fallen");
  JRadioButton r25x = new JRadioButton("25");
  JRadioButton r50x = new JRadioButton("50");
  JRadioButton r100x = new JRadioButton("100");
  JRadioButton r250x = new JRadioButton("250");
  JRadioButton r25y = new JRadioButton("25");
  JRadioButton r50y = new JRadioButton("50");
  JRadioButton r100y = new JRadioButton("100");
  JRadioButton r250y = new JRadioButton("250");

  int screenx = 500;
  int screeny = 500;
  /* Es ist deutlich schneller BufferedImage nur einmal zu erzeugen. Dauert
     sonst ganze 100ms!!! fuer jeden Zyklus mehr! */
  BufferedImage screeni;

  public BufferedImage draw_rectangle(BufferedImage img, int posx, int posy,
                                      int sizex, int sizey, int color) {
  /*BEI DIESER ACH-SO-TOLLEN SUN API IST ES EINFACHER DIE FUNKTIONEN NEU ZU
    PROGRAMMIEREN ALS SIE IN DER API AUSFINDIG ZU MACHEN.
    ICH HABE 2-3 STD GEBRAUCH NUR UM RAUSZUFINDEN WIE ICH NEN BILD ANZEIGE
    ICH HABE 1-2 STD GEBRAUCH NUR UM WEITER HERUASZUFINDEN WIE ICH EINEN
    PIXEL IN DER FABRE VERAENDERE. UND BEVOR ICH WEITERE 2 STD IM NETZ SUCHE WIE
    ICH RECHTECKE ZEICHNE SCHREIB ICH MIR DIE FUNKTION LIEBER IN 10MIN SELBER
    *SIGH*
    setRGB findet man beispielsweise naemlich nicht unter BufferedImage in der
    API */
    int[] data = new int[sizex*sizey];
    for (int n = 0; n < (sizex*sizey);n++) {
      data[n] = color;
    }
    img.setRGB(posx,posy,sizex,sizey,data,0,0);
    return img;
  }

  public void draw_world() {
    //Zeichnet Welt
    long st = System.currentTimeMillis();
    int sizex = this.surface.sizex_get();
    int sizey = this.surface.sizey_get();
    int color;
    for (int nx = 0; nx < sizex; nx++) {
      for (int ny = 0; ny < sizey; ny++) {
        //Ermitteln ob Hasen oder Woelfe auf dem Feld
        Zelle z1 = surface.zelle_get(nx,ny);
        color = 0xFF;
        if (mcolors.isSelected()) {
          int cnt = z1.tiere_count();
          color = 128+cnt*2; //Dunkel und fuer jedes Tier +2 heller
          if (color > 255) {
            color = 255;
          }
        }
        if (z1.contains(2)) { //Wenn Hasen
          color = (color<<0); //Blau (brauch nicht geaendert zu werden)
        } else
        if (z1.contains(1)) { //Wenn Woelfe
          color = (color<<16); //Rot
        } else { //Rasen ist gruen
          color = (0xFF<<8);
        }
        screeni = draw_rectangle(screeni,(screenx/sizex)*nx,
                    (screeny/sizey)*ny,screenx/sizex,screeny/sizey,color);
      }
    }
    update_info();
    this.surfaceimage = new ImageIcon(screeni);
    this.lsurface = new JLabel(this.surfaceimage);
    this.lsurface.setToolTipText("Gr"+Chars.ue+"n: Freier Rasen. Blau: Hasen. Rot: W"+Chars.oe+"lfe");
    this.pimage.removeAll();
    this.pimage.add(lsurface);
    this.frame1.repaint();
    this.frame1.setVisible(true);
    System.out.println("Mgui.draw_world: Hint: Needed "+(System.currentTimeMillis()-st)+" milliseconds");
  }

  public void update_info() {
    //Aktualisiert die Anzeigen der Woelfe, Hasen und Zyklen im Hauptfenster
    int hasen = this.surface.tier_typ_count(2);
    int woelfe = this.surface.tier_typ_count(1);
    this.lhase.setText("Hasen: "+hasen+" ("+(this.surface.hase_current_id_get()-hasen)+")");
    this.lwolf.setText("W"+Chars.oe+"lfe: "+woelfe+" ("+(this.surface.wolf_current_id_get()-woelfe)+")");
    this.lstepp.setText("Zyklus: "+this.surface.cycle_get());
  }

  private void new_world() {
    //Erzeugt eine neue Welt
    int worldx = 50; //Default, brauche r50x nicht abzufragen
    int worldy = 50; //Default, brauche r50y nicht abzufragen
    if (r25x.isSelected()) {
      worldx = 25;
    } else
    if (r100x.isSelected()) {
      worldx = 100;
    } else
    if (r250x.isSelected()) {
      worldx = 250;
    }
    if (r25y.isSelected()) {
      worldy = 25;
    } else
    if (r100y.isSelected()) {
      worldy = 100;
    } else
    if (r250y.isSelected()) {
      worldy = 250;
    }
    if ((worldx*worldy) >= this.config.hase_start_num_get()) {
      this.fsize.setVisible(false);
      this.surface = new World();
      this.surface_orig = new World();
      this.surface = Worldaction.world_new(config, worldx,worldy);
      //System.out.println("World created");
      this.surface_orig = this.surface.exact_clone();
      this.screeni = new BufferedImage(this.screenx, this.screeny, BufferedImage.TYPE_INT_RGB );
      this.draw_world();
      this.bnext.setEnabled(true);
      this.breset.setEnabled(true);
    } else {
      JOptionPane.showMessageDialog(new JPanel(),
      "Fehler: Es m"+Chars.ue+"ssen weniger Hasen zum Startzeitpunkt vorhanden"+
      " sein als Zellen auf der Welt. Reduzieren sie die Anzahl der Hasen zum "+
      "Startzeitpunkt oder vergr"+Chars.oe+Chars.ss+"ern sie die Welt.");
    }
  }

  public void windowActivated(WindowEvent e) {}
  public void windowClosed(WindowEvent e) {}
  public void windowClosing(WindowEvent e) {
    Universe.window_dec(); //Reduzieren window_count; exit bei window_count == 0
  }
  public void windowDeactivated(WindowEvent e) {}
  public void windowDeiconified(WindowEvent e) {}
  public void windowIconified(WindowEvent e) {}
  public void windowOpened(WindowEvent e) {}


  public void actionPerformed(ActionEvent e) {
    //Loest auf welcher Button/Menu den nun vom Benutzer betaetigt wurde
    String cmd = new String();
    cmd = e.getActionCommand();
    System.out.println("Mgui.actionPerformed: Hint: ActionCommand is '"+cmd+"'");
    if (cmd.equals("mdup")) { //Extras->Neues Fenster
      Mgui f1 = new Mgui();
      f1.instance();
    }
    if (cmd.equals("mabo")) { //Hilfe->About Dialog
      this.f2.showuser();
    }
    if (cmd.equals("bnewok")) { //Neue Welt OK Button
      this.new_world();
    }
    if (cmd.equals("bnew")) { //Neu Welt Groesse Auswahl anzeigen
      this.fsize.setVisible(true);
    }
    if (cmd.equals("bnewabort")) { //Neue Welt Abbrechen Button
      this.fsize.setVisible(false);
    }
    if (cmd.equals("bnex")) { //Naechster Zyklus
       this.surface = Worldaction.world_cycle(surface,config);
       draw_world();
    }
    if (cmd.equals("bres")) { //Welt Reset
      this.surface = new World();
      this.surface = this.surface_orig.exact_clone();
      this.draw_world();
    }
    if (cmd.equals("mhp")) { //Hilfe->Zur Homepage
      this.open_html("http://www.marwedels.de/malte");
    }
    if (cmd.equals("mrea")) { //Hilfe-> Readme
      //open_html("file:readme.html");
    }
    if (cmd.equals("bopt")) { //Optionen Dialog anzeigen
      if (!this.fopt.isVisible()) { //Wenn er noch nicht angezeigt wird
        this.update_options_dlg();
        this.fopt.setVisible(true);
      }
    }
    if (cmd.equals("mook")) { //OK im Optionen Dialog
      if (this.update_config()) {
        this.fopt.setVisible(false);
      }
    }
    if (cmd.equals("moab")) { //Abbrechen im Optionen Dialog
      this.update_options_dlg();
      this.fopt.setVisible(false);
    }
    if (cmd.equals("mex")) { //Fenster Schliessen
      this.frame1.setVisible(false);
      Universe.window_dec();
    }
    if (cmd.equals("mcol")) { //Farben an/aus
      if (surfaceimage != null) { //Wenn Welt aufgebaut (kein Splashscreen mehr)
        draw_world();
      }
    }
  }

  public void open_html(String file) {
    /*
    //Und ProcessBuilder ist mal wieder nicht von jedem java compiler verstanden
    //worden!!!!!. ProcessBuilder cannot be resolved to a type  >:(
    String viewers[] = {"mozilla","mozilla-firefox","konqueror","safari","opera"};
    ProcessBuilder pb = new ProcessBuilder();
    for (int n = 0; n < viewers.length; n++) {
      pb.command(viewers[n], file);
      try {
        Process p = pb.start();
        break;
      } catch (Exception e) {
        System.out.println("Mgui.open_html: Warning: Running of "+viewers[n]+" failed");
        if ((n+1) == viewers.length) {
          JOptionPane.showMessageDialog(new JPanel(),"Sorry, faild to start a web-browser.");
        }
      }
    }
*/
  }

  public void instance() {
    //Initialisiert das Hauptfenster und zeigt es an.
    frame1 = new JFrame("Torusworld   (Version 0.3.1)");
    lstepp = new JLabel("Zyklus: ?");
    lstepp.setToolTipText("Der aktuelle Zyklus der Welt");
    lhase = new JLabel("Hasen: ? (?)");
    lhase.setToolTipText("Anzahl der lebenden Hasen. In Klammern die Anzahl der bisher gestorbenen Hasen");
    lwolf = new JLabel("W"+Chars.oe+"lfe: ? (?)");
    lwolf.setToolTipText("Anzahl der lebenden W"+Chars.oe+"lfe. In Klammern die Anzahl der bisher gestorbenen W"+Chars.oe+"lfe");
    JPanel pprime = new JPanel();
    JPanel plabels = new JPanel();
    pimage = new JPanel();
    JPanel pbuttons = new JPanel();
    JButton bnew = new JButton("Neu");
    bnew.setToolTipText("Neue zuf"+Chars.ae+"llige Welt erzeugen");
    bnew.setActionCommand("bnew");
    bnew.addActionListener(this);
    breset = new JButton("Restart");
    breset.setToolTipText("Zustand zum Zyklus 0 dieser Welt wiederherstellen");
    breset.setActionCommand("bres");
    breset.addActionListener(this);
    breset.setEnabled(false);
    JButton boptions = new JButton("Optionen");
    boptions.setToolTipText("Einstellungen der Welt");
    boptions.setActionCommand("bopt");
    boptions.addActionListener(this);
    bnext = new JButton("N"+Chars.ae+"chster Zyklus");
    bnext.setToolTipText("Hase und W"+Chars.oe+"lfe bewegen sich");
    bnext.setActionCommand("bnex");
    bnext.addActionListener(this);
    bnext.setEnabled(false);
    JMenuBar mbar = new JMenuBar();
    JMenu mfile = new JMenu("Datei");
    JMenuItem mload = new JMenuItem("Lade Welt");
    mload.setActionCommand("mloa");
    mload.addActionListener(this);
    mload.setEnabled(false);
    JMenuItem msave = new JMenuItem("Speichere Welt");
    msave.setActionCommand("msav");
    msave.addActionListener(this);
    msave.setEnabled(false);
    JMenuItem mexit = new JMenuItem("Fenster Schlie"+Chars.ss+"en");
    mexit.setActionCommand("mex");
    mexit.addActionListener(this);
    JMenu mextras = new JMenu("Extras");
    JMenuItem mpovexp = new JMenuItem("POV-Ray Export");
    mpovexp.setActionCommand("mpov");
    mpovexp.addActionListener(this);
    mpovexp.setEnabled(false);
    JMenuItem mduplicate = new JMenuItem("Weiteres Fenster");
    mduplicate.setActionCommand("mdup");
    mduplicate.addActionListener(this);
    JMenuItem mgraph = new JMenuItem("Verlaufsgrafik");
    mgraph.setActionCommand("mgra");
    mgraph.addActionListener(this);
    mgraph.setEnabled(false);
    JMenuItem mlang = new JMenuItem("Set to English");
    mlang.setActionCommand("mlan");
    mlang.addActionListener(this);
    mlang.setEnabled(false);
    JMenu mhelp = new JMenu("Hilfe");
    JMenuItem mabout = new JMenuItem(""+Chars.Ue+"ber");
    mabout.setActionCommand("mabo");
    mabout.addActionListener(this);
    JMenuItem mreadme = new JMenuItem("Liesmich - Hilfe");
    mreadme.setActionCommand("mrea");
    mreadme.addActionListener(this);
    mreadme.setEnabled(false);
    JMenuItem mhp = new JMenuItem("Zur Homepage");
    mhp.setActionCommand("mhp");
    mhp.addActionListener(this);
    mhp.setEnabled(false);
    JLabel lsurface = new JLabel(splashimage);
    lsurface.setToolTipText("Splash Image made with POV-Ray");
    mfile.add(mload);
    mfile.add(msave);
    mfile.add(mexit);
    mbar.add(mfile);
    mextras.add(mpovexp);
    mextras.add(mduplicate);
    mextras.add(mgraph);
    mextras.add(mlang);
    mcolors.setActionCommand("mcol");
    mcolors.addActionListener(this);
    mextras.add(mcolors);
    mbar.add(mextras);
    mhelp.add(mabout);
    mhelp.add(mreadme);
    mhelp.add(mhp);
    mbar.add(mhelp);
    plabels.setLayout(new FlowLayout());
    plabels.add(lstepp);
    plabels.add(lhase);
    plabels.add(lwolf);
    pimage.add(lsurface);
    pbuttons.setLayout(new FlowLayout());
    pbuttons.add(bnew);
    pbuttons.add(breset);
    pbuttons.add(boptions);
    pbuttons.add(bnext);
    pprime.setLayout(new BorderLayout());
    pprime.add(plabels,BorderLayout.NORTH);
    pprime.add(pimage,BorderLayout.CENTER);
    pprime.add(pbuttons,BorderLayout.SOUTH);
    frame1.add(pprime);
    frame1.setJMenuBar(mbar);
    frame1.setLocation(212,70); //Center of an 1024*788 screen
    frame1.setSize(600,630);
    frame1.setVisible(true);
    Universe.window_inc(); //window counter erhoehen
    this.f2.about();
    this.make_options();
    this.update_options_dlg();
    this.make_size_dlg();
    frame1.addWindowListener(this);
  }

  private void update_options_dlg() {
    //Im Optionen Dialog die Werte aus der config anzeigen
    this.ths.setText((String)(Integer.toString(this.config.hase_start_num_get())));
    this.tws.setText((String)(Integer.toString(this.config.wolf_start_num_get())));
    this.thm.setText((String)(Integer.toString(this.config.hase_max_num_get())));
    this.twm.setText((String)(Integer.toString(this.config.wolf_max_num_get())));
    this.thz.setText((String)(Integer.toString(this.config.hase_alter_max_get())));
    this.twz.setText((String)(Integer.toString(this.config.wolf_alter_max_get())));
    this.thw.setText((String)(Integer.toString(this.config.hase_nachwuchs_get())));
    this.tww.setText((String)(Integer.toString(this.config.wolf_nachwuchs_get())));
    this.cworldinf.setSelected(this.config.area_inf_get());
    this.cworldfreefall.setSelected(this.config.area_freefall_get());
    this.cstrictmax.setSelected(this.config.strict_max_num_get());
  }

  private boolean update_config() {
    //Werte aus Optionen Dialog konvertieren
    //und bei Fehleingaben Meldung anzeigen
    boolean should_close = true;
    try {
      if (this.config.hase_start_num_set(Integer.parseInt(this.ths.getText())) < 0) {
         JOptionPane.showMessageDialog(new JPanel(),
                      "Fehler: '"+shs+"' Au"+Chars.ss+"erhalb des Wertebereichs");
         should_close = false;
      }
      if (this.config.wolf_start_num_set(Integer.parseInt(this.tws.getText()))< 0) {
         JOptionPane.showMessageDialog(new JPanel(),
                      "Fehler: '"+sws+"' Au"+Chars.ss+"erhalb des Wertebereichs");
         should_close = false;
      }
      if (this.config.hase_max_num_set(Integer.parseInt(this.thm.getText()))< 0) {
         JOptionPane.showMessageDialog(new JPanel(),
                      "Fehler: '"+shm+"' Au"+Chars.ss+"erhalb des Wertebereichs");
         should_close = false;
      }
      if (this.config.wolf_max_num_set(Integer.parseInt(this.twm.getText()))< 0) {
         JOptionPane.showMessageDialog(new JPanel(),
                      "Fehler: '"+swm+"' Au"+Chars.ss+"erhalb des Wertebereichs");
         should_close = false;
      }
      if (this.config.hase_alter_max_set(Integer.parseInt(this.thz.getText()))< 0) {
         JOptionPane.showMessageDialog(new JPanel(),
                      "Fehler: '"+shz+"' Au"+Chars.ss+"erhalb des Wertebereichs");
         should_close = false;
      }
      if (this.config.wolf_alter_max_set(Integer.parseInt(this.twz.getText()))< 0) {
         JOptionPane.showMessageDialog(new JPanel(),
                      "Fehler: '"+swz+"' Au"+Chars.ss+"erhalb des Wertebereichs");
         should_close = false;
      }
      if (this.config.hase_nachwuchs_set(Integer.parseInt(this.thw.getText()))< 0) {
         JOptionPane.showMessageDialog(new JPanel(),
                      "Fehler: '"+shw+"' Au"+Chars.ss+"erhalb des Wertebereichs");
         should_close = false;
      }
      if (this.config.wolf_nachwuchs_set(Integer.parseInt(this.tww.getText()))< 0) {
         JOptionPane.showMessageDialog(new JPanel(),
                      "Fehler: '"+sww+"' Au"+Chars.ss+"erhalb des Wertebereichs");
         should_close = false;
      }
      this.config.area_inf_set(this.cworldinf.isSelected());
      this.config.area_freefall_set(this.cworldfreefall.isSelected());
      this.config.strict_max_num_set(this.cstrictmax.isSelected());
    } catch (Exception e) { //Bei Fehleingabe urspruengiche Werte anzeigen
      this.update_options_dlg();
      should_close = false;
      JOptionPane.showMessageDialog(new JPanel(),
      "Fehler: Manche Werte sind m"+Chars.oe+"glicherweise keine Zahlen oder sind Au"+Chars.ss+"erhalb des Wertebereichs.");
    }
    return should_close;
  }

  private void make_size_dlg() {
     //Erzeugt den Dialog zur Auswahl der Welt Groesse
    fsize = new JFrame("Welt gr"+Chars.oe+Chars.ss+"e");
    JPanel psize = new JPanel();
    JPanel psizex = new JPanel();
    JPanel psizey = new JPanel();
    JPanel pbuttons = new JPanel();
    JButton bnewok = new JButton("OK");
    ButtonGroup groupx = new ButtonGroup();
    ButtonGroup groupy = new ButtonGroup();
    bnewok.setActionCommand("bnewok");
    bnewok.addActionListener(this);
    JButton bnewabort = new JButton("Abbrechen");
    bnewabort.setActionCommand("bnewabort");
    bnewabort.addActionListener(this);
    psizex.add(r25x);
    psizex.add(r50x);
    psizex.add(r100x);
    psizex.add(r250x);
    psizey.add(r25y);
    psizey.add(r50y);
    psizey.add(r100y);
    psizey.add(r250y);
    groupx.add(r25x);
    groupx.add(r50x);
    groupx.add(r100x);
    groupx.add(r250x);
    groupy.add(r25y);
    groupy.add(r50y);
    groupy.add(r100y);
    groupy.add(r250y);
    r50x.setSelected(true);
    r50y.setSelected(true);
    psize.setLayout(new GridLayout(3,1));
    psize.add(psizex);
    psize.add(psizey);
    psize.add(pbuttons);
    pbuttons.add(bnewabort);
    pbuttons.add(bnewok);
    fsize.add(psize);
    fsize.setSize(250,150);
    fsize.setLocation(400,300);
  }

  private void make_options() {
    //Erzeugt den Dialog zum Einstellen der Optionen
    fopt = new JFrame("Options");
    JLabel lhs = new JLabel(shs+":");
    JLabel lws = new JLabel(sws+":");
    JLabel lhm = new JLabel(shm+":");
    JLabel lwm = new JLabel(swm+":");
    JLabel lhz = new JLabel(shz+":");
    JLabel lwz = new JLabel(swz+":");
    JLabel lhw = new JLabel(shw+":");
    JLabel lww = new JLabel(sww+":");
    JLabel spacer1 = new JLabel("");
    JButton bok = new JButton("OK");
    bok.setActionCommand("mook");
    bok.addActionListener(this);
    JButton bab = new JButton("Abbrechen");
    bab.setActionCommand("moab");
    bab.addActionListener(this);
    JPanel popt = new JPanel();
    popt.setLayout(new GridLayout(11,2));
    popt.add(lhs);
    ths.setToolTipText("Min: 0; Max: 62499");
    popt.add(ths);
    popt.add(lws);
    tws.setToolTipText("Min: 0; Max: 999999");
    popt.add(tws);
    popt.add(lhm);
    thm.setToolTipText("Min: 0; Max: 999999");
    popt.add(thm);
    popt.add(lwm);
    twm.setToolTipText("Min: 0; Max: 999999");
    popt.add(twm);
    popt.add(spacer1);
    cstrictmax.setToolTipText("Deaktiviert: Beim "+Chars.Ue+"berschreiten des Tiere Maximums sinkt nur die Vermehrungswahrscheinlichkeit");
    popt.add(cstrictmax);
    popt.add(lhz);
    thz.setToolTipText("Min: 0");
    popt.add(thz);
    popt.add(lwz);
    twz.setToolTipText("Min: 0");
    popt.add(twz);
    popt.add(lhw);
    thw.setToolTipText("Min: 0; Max: 100");
    popt.add(thw);
    popt.add(lww);
    tww.setToolTipText("Min: 0; Max: 100");
    popt.add(tww);
    cworldinf.setToolTipText("Unendlicher Torus, oder begrenztes Rechteck");
    popt.add(cworldinf);
    cworldfreefall.setToolTipText("Nur bei begrenzter Welt relevant");
    popt.add(cworldfreefall);
    popt.add(bab);
    popt.add(bok);
    fopt.add(popt);
    fopt.setSize(500,300);
    fopt.setLocation(400,300);
  }

}

