/** Speichert alle Einstellungen die noetig sind um einen Zyklus zu berechnen
Die Groesse der Welt ist deswegen in der Klasse Welt gespeichert weil sich
dieser Parameter nicht nachtraeglich aendern laesst.
Die fortlaufende ID der Tiere ist in der Welt gespeichert, da sich diese
einerseits kontinuierlich aendert und immer bei 1 beginnt. Andererseits
veraendert so die Berechnung einen Zyklus kein Werte in der Klasse Settings
 */

/*
    Copyright (C) 2006 by Malte Marwedel    m.marwedel < AT > onlinehome.de

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

package Settings;
/*
Die Standard Werte entsprechen der Vorgabe der Aufgabenstellung.
Bei Setterfunktionen, die mehr als einen boolschen Wert setzen (z.B. int) wird
eine 0 bei einem gueltigem Wert und -1 bei einem fehlerhaften Wert zurueck
gegeben. Bei -1 wurde daher kein Wert gesetzt.
*/

public class Settings {

  /*area_inf: true: Magische Tunnel von einer zur anderen Weltseite (Torus Welt)
    false: Keine Tunnel (Rechteck Welt)
    area_freefall: false: Tiere bemerken Wand und laufen in die entgegengesetzte
                    Richtung
                   true: Keine Begrenzung -> Tiere fallen von der Welt -> Tot
  */
  private boolean area_inf = true;
  private boolean area_freefall = false;

  /* grass_inf true: Hasen haben unendlich viel zu essen
     false: Gras w�hst nach und reicht eventuell nicht
     grass_grow_rate: Wachstum pro Zyklus
     grass_max_zelle: Maximaler Vorrat pro Zelle
  */
  private boolean grass_inf = true;
  private int grass_grow_rate = 10;
  private int grass_max_zelle = 100;

  /* strict_max_num: true: sobald Limmit an Tieren erreicht k�nen keine neuen
      mehr entstehen. Nachteil ist dass die Tiere die zuerst berprft werden
      noch Nachwuchs bekommen k�nen, andere mit gleichen Bedingungen aber nicht
     mehr -> Ortsabhaengig
     false: Wurde im letztem Zyklus die Zahl ueberschritten, so werden keine
        neuen geboren. Vorteil: Gleichberechtigung aller Tiere. Nachteil: Anzahl
        der Tiere kan stark schwingen.
     hase_max_num: Limmit der Hasen
     wolf_max_num: Limmit der W�fe
  */
  private boolean strict_max_num = true; //true
  private int hase_max_num = 20000;//20000
  private int wolf_max_num = 5000;//5000

  /* Verhalten: 0: Zufaellige Bewegung
      1: Zufaellige Bewegung von Genen in ihrer Wahrscheinlichkeit beeinflusst
      2: Intelligent durch Erkennung der Umgebung
  */
  private int hase_verhalten = 0;
  private int wolf_verhalten = 0;

  /* hase_ Wahrscheinlichkeit des Nachwuchs in % pro Zyklus
     wolf_ Wahrscheinlichkeit des Nachwuchs in % bei gefressenem Hase
  */
  private int hase_nachwuchs = 35;//35
  private int wolf_nachwuchs = 40;//40

  /* Maximales Zyklus Alter der Tiere */
  private int hase_alter_max = 4;
  private int wolf_alter_max = 8;//8

  /*Anzahl der Hasen zum Start */
  private int hase_start_num = 300;
  private int wolf_start_num = 100;//100

  /* hase_complex_food false: Vermehrungswahrscheinlichtkeit jede Runde
                       true: Hase kann an Unterern�rung sterben
                             Nur ein Wolf wird pro Hase satt.
     wolf_complex_food: false: Vermehrungswahrscheinlichtkeit bei Hase essen
                        true: Wolf kann an unterernaehrung sterben
     Wenn >= hase_die_hunger -> Hase Tot
     Wenn >= wolf_die_hunger -> Wolf Tot
  */
  private boolean hase_complex_food = false;
  private boolean wolf_complex_food = false;
  private int hase_die_hunger = 3;
  private int wolf_die_hunger = 6;

  /* wolf_eat_wolf false: kein Kannibalismus
     true: Sobald hunger >= wolf_eat_wolf_hunger ->
            Wolf mit hoechstem Hunger (schwaechster) wird getoetet, alle anderen
            reduzieren ihren Hunger um max((10/Woelfe_nr), 1)
  */
  private boolean wolf_eat_wolf = false;
  private int wolf_eat_wolf_hunger = 5;

  /* hase_fight_wolf true: Viele Hasen koennen Woelfe besiegen
    false: Geht eben nicht
    hase_needed Verhaeltnis von Woelfen zu Hasen
    hase_die Anzahl in % der Hasen die trotzdem sterben
  */
  private boolean hase_fight_wolf = false;
  private int hase_needed = 10;
  private int hase_die = 90;

  public boolean area_inf_get() {
    return area_inf;
  }
  public void area_inf_set(boolean n_inf) {
    area_inf = n_inf;
  }
  public boolean area_freefall_get() {
    return area_freefall;
  }
  public void area_freefall_set(boolean n_freefall) {
    area_freefall = n_freefall;
  }
  public boolean grass_inf_get() {
    return grass_inf;
  }
  public int grass_grow_rate_get() {
    return grass_grow_rate;
  }
  public int grass_max_zelle_get() {
    return grass_max_zelle;
  }
  public boolean strict_max_num_get() {
    return strict_max_num;
  }
  public void strict_max_num_set(boolean n_strict_max_num) {
    strict_max_num = n_strict_max_num;
  }
  public int hase_max_num_get() {
    return hase_max_num;
  }
  public int hase_max_num_set(int n_maxnum) {
    if ((n_maxnum >= 0) && (n_maxnum < 1000000)) {
      hase_max_num = n_maxnum;
      return 0;
    } else {
      System.out.println("hase_max_num_set: Error: Out of range");
      return -1;
    }
  }
  public int wolf_max_num_get() {
    return wolf_max_num;
  }
  public int wolf_max_num_set(int n_maxnum) {
    if ((n_maxnum >= 0) && (n_maxnum < 1000000)) {
      wolf_max_num = n_maxnum;
      return 0;
    } else {
      System.out.println("wolf_max_num_set: Error: Out of range");
      return -1;
    }
  }
  public int hase_verhalten_get() {
    return hase_verhalten;
  }
  public int wolf_verhalten_get() {
    return wolf_verhalten;
  }
  public int hase_nachwuchs_get() {
    return hase_nachwuchs;
  }
  public int hase_nachwuchs_set(int n_nachwuchs) {
    if ((n_nachwuchs >= 0) && (n_nachwuchs <= 100)) {
      hase_nachwuchs = n_nachwuchs;
      return 0;
    } else {
      System.out.println("hase_nachwuchs_set: Error: Out of range");
      return -1;
    }
  }
  public int wolf_nachwuchs_get() {
    return wolf_nachwuchs;
  }
  public int wolf_nachwuchs_set(int n_nachwuchs) {
    if ((n_nachwuchs >= 0) && (n_nachwuchs <= 100)) {
      wolf_nachwuchs = n_nachwuchs;
      return 0;
    } else {
      System.out.println("wolf_nachwuchs_set: Error: Out of range");
      return -1;
    }
  }
  public int hase_alter_max_get() {
    return hase_alter_max;

  }
  public int hase_alter_max_set(int n_alter) {
    if (n_alter >= 0) {
      hase_alter_max = n_alter;
      return 0;
    } else {
      System.out.println("hase_alter_max_set: Error: Out of range");
      return -1;
    }
  }
  public int wolf_alter_max_get() {
    return wolf_alter_max;
  }
  public int wolf_alter_max_set(int n_alter) {
    if (n_alter >= 0) {
      wolf_alter_max = n_alter;
      return 0;
    } else {
      System.out.println("wolf_alter_max_set: Error: Out of range");
      return -1;
    }
  }
  public int hase_start_num_get() {
    return hase_start_num;
  }
  public int hase_start_num_set(int n_startnum) {
    if ((n_startnum >= 0) && (n_startnum < 62500)) { //Maximum liegt unter 250
      hase_start_num = n_startnum;
      return 0;
    } else {
      System.out.println("hase_start_num_set: Error: Out of range");
      return -1;
    }
  }
  public int wolf_start_num_get() {
    return wolf_start_num;
  }
  public int wolf_start_num_set(int n_startnum) {
    if ((n_startnum >= 0) && (n_startnum < 1000000)) {
      wolf_start_num = n_startnum;
      return 0;
    } else {
      System.out.println("wolf_start_num_set: Error: Out of range");
      return -1;
    }
  }
  public boolean hase_complex_food_get() {
    return hase_complex_food;
  }
  public boolean wolf_complex_food_get() {
    return wolf_complex_food;
  }
  public int hase_die_hunger_get() {
    return hase_die_hunger;
  }
  public int wolf_die_hunger_get() {
    return wolf_die_hunger;
  }
  public boolean wolf_eat_wolf_get() {
    return wolf_eat_wolf;
  }
  public int wolf_eat_wolf_hunger_get() {
    return wolf_eat_wolf_hunger;
  }
  public boolean hase_fight_wolf_get() {
    return hase_fight_wolf;
  }
  public int hase_needed_get() {
    return hase_needed;
  }
  public int hase_die_get() {
    return hase_die;
  }


}
