/** Eine Zelle auf der Welt */

/*
    Copyright (C) 2006 by Malte Marwedel    m.marwedel < AT > onlinehome.de

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

package Zelle;

import Tier.*;


public class Zelle {

  private char landtype; //Typ des Bondens der Zelle
  private int grass; //Wieviel Nahrung die Zelle gerade enthaelt

  private Tier[] tiere; //Array mit den Tieren auf dem Feld
  private int tiere_free_guess; //Beschleunigt die tier_add Funktion

  private boolean init_done = false;  //Ob Zelle initialisiert

  public void make(int tier_count, char n_type, int n_grass) {
    //Initialisert die Zelle
    if (this.init_done == false) {
      this.init_done = true;
      this.tiere = new Tier[tier_count];
      this.landtype = n_type;
      this.grass = n_grass;
      this.tiere_free_guess = 0;
      if (n_grass < 0) {
        System.out.println("Zelle.new: Warning: grass was set to lower than zero");
      }
    } else {
      System.out.println("Zelle.new: Error: make() can be called only once");
    }
  }

  public Zelle exact_clone() {
    //Erzeugt eine exakte Kopie der Zelle
    Zelle z2 = new Zelle();
    z2.make(this.tiere.length,this.landtype,grass);
    for (int n = 0; n < this.tiere.length; n++) {
      if (this.tiere[n] != null) {
        z2.tier_set(n,this.tiere[n].exact_clone());
        z2.tiere_free_guess = this.tiere_free_guess;

      }
    }
    return z2;
  }

  public int tier_add(Tier n_tier) {
    /*Sucht eine freie Stelle im Array und fuegt n_tier dort ein.
     Bei vollem Array wird ein neues erzeugt und der alte Inhalt kopiert,
     dies duerfe aber nicht sonderlich effizient sein, weswegen versucht werden
     sollte moeglichst zu Beginn ein Array mit der richtigen Groesse zu
     erzeugen.*/
    int size = this.tiere.length;
    int tfg = this.tiere_free_guess;
    if (tfg< size) { //Optimierung
      if (tiere[tfg] == null) {
        this.tiere[tfg] = n_tier;
        this.tiere_free_guess++;
        //System.out.println("tiere_free_guess has a hit :-)");
        return tfg;
      }
    }
    for (int n = 0; n < size; n++) {
      if (this.tiere[n] == null) {
        this.tiere[n] = n_tier;
        this.tiere_free_guess = n+1;
        return n;
      }
    }
    /*Mhh kein freier Speicher mehr, jetzt wirds schwieriger.
      Wir erzeugen in dem Fall gleich 1/3 der bisherigen Groesse an leeren
      Eintraegen um bei einem erneutem Aufruf deutlich schneller zu sein.
      Der Ueberlauf kommt primaer beim Einfuegen des Nachwuchs zustande.
      In der Praxis beschleunigt dies Worldaction.tiere_nachwuchs() um einen
      erheblichen Faktor! */
    Tier[] n_tiere = new Tier[size+1+size/3]; //Neues Array
    for (int n = 0; n < size; n++) { //Kopieren
      n_tiere[n] = tiere[n];
    }
    n_tiere[size] = n_tier; //Neus Tier hinzufuegen
    this.tiere_free_guess = size+1;
    this.tiere = n_tiere;
    return size;
  }

  public char landtype_get() {
    //Was fuer eine Landschaft die Zelle hat
    if (this.init_done) {
      return this.landtype;
    } else {
      System.out.println("Zelle.landtype_get: Error: Please call make() first");
      return ' ';
    }
  }

  public int grass_get() {
    //Wieviel Pflanzliche Nahrung die Zelle bietet
    if (this.init_done) {
      return this.grass;
    } else {
      System.out.println("Zelle.grass_get: Error: Please call make() first");
      return -1;
    }
  }

  public void grass_set(int n_grass) {
    //Pflanzliche Nahrung festsetzen
    this.grass = n_grass;
    if (n_grass < 0) {
      System.out.println("Zelle.grass_set: Warning: grass was set to lower than zero");
    }
    if (!this.init_done) {
      System.out.println("Zelle.grass_set: Warning: Better to call make() first");
    }
  }

  public void tier_set(int tier_no, Tier tier_data) {
    //Tier Platzieren
    if (this.init_done) {
      if ((tier_no >= 0) && (tier_no < this.tiere.length)) {
        this.tiere[tier_no] = tier_data;
        if (tier_data == null) { //Freies Feld -> wiederverwertbar
          this.tiere_free_guess = tier_no;
        }
      } else {
        System.out.println("Zelle.tier_set: Error: tier_no out of range");
      }
    } else {
      System.out.println("Zelle.tier_set: Error: Please call make() first");
    }
  }

  public Tier tier_get(int tier_no) {
    //Gibt ein Tier zurueck
    if (this.init_done) {
      if ((tier_no >= 0) && (tier_no < this.tiere.length)) {
        return this.tiere[tier_no];
      } else {
        System.out.println("Zelle.tier_get: Error: Tier out of range");
        return null;
      }
    } else {
      System.out.println("Zelle.tier_get: Error: Please call make() first");
      return null;
    }
  }

  public boolean contains(int tier_type) {
    //Gibt True zurueck sofern die Zelle ein Tier vom Typ tier_type enthaelt
    for (int n = 0; n < this.tiere.length; n++) {
      if (this.tiere[n] != null) {
        if (this.tiere[n].type_get() == tier_type) {
          return true;
        }
      }
    }
    return false;
  }

  public int tiere_count() {
    //Gibt die Anzahl der Tiere zurueck,
    //Tot oder Lebendig wird nicht beruecksichtigt
    int no = 0;
    for (int n = 0; n < this.tiere.length; n++) {
      if (this.tiere[n] != null) {
         no++;
      }
    }
    return no;
  }

  public int length() {
    return tiere.length;
  }

  public int tier_typ_count(int tiertyp) {
    //Zahelt die Anzahl eines Tiertyps in der Zelle
    int no = 0;
    for (int n = 0; n < this.tiere.length; n++) {
      if (this.tiere[n] != null) {
        if (tiere[n].type_get() == tiertyp) {
          no++;
        }
      }
    }
    return no;
  }


}
