#include "main.h"
#include "timebase.h"

// at 250 Khz prescaler 64
/*
#define T0COUNT     (XTAL / 64 / 64)	                         // 61
#define T0SECERR    (XTAL - 64L * 64 * T0COUNT)	         // 144
#define T0COUNTSEC  (T0COUNT + T0SECERR / 64)	                 // 63
#define T0MINERR    (XTAL - 64 * (63 * T0COUNT + T0COUNTSEC))  // 16
#define T0COUNTMIN  (T0COUNTSEC + (T0MINERR * 60 + 32) / 64)  // 78
*/

//at 12MHZ prescaler 1024
/*
#define T0COUNT     (XTAL / 1024 / 64)	                         // 183
#define T0SECERR    (XTAL - 1024L * 64 * T0COUNT)	         // 6912
#define T0COUNTSEC  (T0COUNT + T0SECERR / 1024)	                 // 189
#define T0MINERR    (XTAL - 1024 * (63 * T0COUNT + T0COUNTSEC))  // 768
#define T0COUNTMIN  (T0COUNTSEC + (T0MINERR * 60 + 512) / 1024)  // 234
*/

//at 1MHZ prescaler 1024

#define T0COUNT     (XTAL / 1024 / 64)	                         // 15
#define T0SECERR    (XTAL - 1024L * 64 * T0COUNT)	         // 16960
#define T0COUNTSEC  (T0COUNT + T0SECERR / 1024)	                 // 0
#define T0MINERR    (XTAL - 1024 * (63 * T0COUNT + T0COUNTSEC))  // 576
#define T0COUNTMIN  (T0COUNTSEC + (T0MINERR * 60 + 512) / 1024)  // 65
/*

#define FOO T0COUNT
#warning T0COUNT=
#include "warnheader.h"

#define FOO T0SECERR
#warning T0SECERR=
#include "warnheader.h"

#define FOO T0COUNTSEC
#warning T0COUNTSEC=
#include "warnheader.h"

#define FOO T0MINERR
#warning T0MINERR=
#include "warnheader.h"

#define FOO T0COUNTMIN
#warning T0COUNTMIN=
#include "warnheader.h"
*/


// 234 = 12000000 Hz
// 233 = 12000017 Hz = 4s/month


u8 timeflags;
u8 dcf77_period;
u8 dcf77_pulse;
u8 ct_64Hz;					// 64 Hz counter (4sec)


void timebase_init( void )
{
	TCCR0A = 0;
	TCCR0B = 1<<CS02 | 1<<CS00;			// prescale = 1024
	//TCCR0B = 1<<CS02;			// prescale = 256
	TCNT0 = 0;
	TIMSK0 = 1<<TOIE0;				// interrupt enable
}


SIGNAL (SIG_OVERFLOW0)
{
  static u8 dcf77_time, old_dcf77;
					// DCF77 receive
  if( dcf77_time != 0xFF )			// stop on 0xFF
    dcf77_time++;				// count ticks
  if( (DCF77_PIN ^ old_dcf77) & 1<<DCF77 ){	// pin changed ?
    old_dcf77 ^= 0xFF;				// change old flag
    if( old_dcf77 & 1<<DCF77 ){
      dcf77_period = dcf77_time;		// store ticks of period
      dcf77_time = 0;				// count next period
    }else{
      dcf77_pulse = dcf77_time;			// store ticks of pulse
    }
  }
					// time base 1 second
  TCNT0 = (u16)(256 - T0COUNT);			// reload per tick: -183
  if( ++ct_64Hz & 0x3F ){			// 64 ticks = one second
    timeflags = 1<<ONE_TICK;			// one tick over
    return;
  }
  TCNT0 = (u16)(256 - T0COUNTSEC);		// reload per second: -189
  if( timeflags & (1<< ONE_MINUTE ))
    TCNT0 = (u16)(256 - T0COUNTMIN);		// reload per minute: -234
  timeflags = 1<<ONE_SECOND^1<<ONE_TICK;	// one tick, one second over
}


void sync_sec( void )			// synchronize by DCF77
{
  TCNT0 = (u16)(256 - T0COUNTMIN);
  ct_64Hz = 0;
  timeflags = 0;
}
